/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.monitor;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class TransactionMonitorScheduler
extends LifecycleAdapter {
    private final TransactionMonitor transactionMonitor;
    private final JobScheduler scheduler;
    private final long checkIntervalMillis;
    private JobHandle monitorJobHandle;

    public TransactionMonitorScheduler(TransactionMonitor transactionMonitor, JobScheduler scheduler, long checkIntervalMillis) {
        this.transactionMonitor = transactionMonitor;
        this.scheduler = scheduler;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    public void start() {
        if (this.checkIntervalMillis > 0L) {
            this.monitorJobHandle = this.scheduler.scheduleRecurring(Group.TRANSACTION_TIMEOUT_MONITOR, (Runnable)this.transactionMonitor, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.monitorJobHandle != null) {
            this.monitorJobHandle.cancel();
        }
    }
}

