/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.util.Collection;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.diagnostics.providers.ConfigDiagnostics;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.diagnostics.providers.TransactionRangeDiagnostics;
import org.neo4j.kernel.diagnostics.providers.VersionDiagnostics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.FeatureToggles;

public class DbmsDiagnosticsManager {
    private static final int CONCISE_DATABASE_DUMP_THRESHOLD = FeatureToggles.getInteger(DbmsDiagnosticsManager.class, (String)"conciseDumpThreshold", (int)10);
    private final Dependencies dependencies;
    private final Log log;

    public DbmsDiagnosticsManager(Dependencies dependencies, LogService logService) {
        this.log = logService.getInternalLog(DiagnosticsManager.class);
        this.dependencies = dependencies;
    }

    public void dumpSystemDiagnostics() {
        this.dumpSystemDiagnostics(this.log);
    }

    public void dumpDatabaseDiagnostics(Database database) {
        this.dumpDatabaseDiagnostics(database, this.log, false);
    }

    public void dumpAll() {
        this.dumpAll(this.log);
    }

    public void dumpAll(Log log) {
        this.dumpSystemDiagnostics(log);
        this.dumpAllDatabases(log);
    }

    private void dumpAllDatabases(Log log) {
        Collection<?> values = this.getDatabaseManager().registeredDatabases().values();
        if (values.size() > CONCISE_DATABASE_DUMP_THRESHOLD) {
            values.forEach(context -> this.dumpConciseDiagnostics(context.database(), log));
        } else {
            values.forEach(dbCtx -> this.dumpDatabaseDiagnostics(dbCtx.database(), log, true));
        }
    }

    private void dumpConciseDiagnostics(Database database, Log log) {
        this.dumpAsSingleMessage(log, stringJoiner -> {
            this.dumpDatabaseSectionName(database, stringJoiner::add);
            DbmsDiagnosticsManager.logDatabaseStatus(database, stringJoiner::add);
        });
    }

    private void dumpSystemDiagnostics(Log log) {
        this.dumpAsSingleMessage(log, stringJoiner -> {
            DiagnosticsManager.section(stringJoiner::add, (String)"System diagnostics");
            DiagnosticsManager.dump(SystemDiagnostics.class, (Log)log, stringJoiner::add);
            DiagnosticsManager.dump((DiagnosticsProvider)new ConfigDiagnostics((Config)this.dependencies.resolveDependency(Config.class)), (Log)log, stringJoiner::add);
            this.dependencies.resolveTypeDependencies(DiagnosticsProvider.class).forEach(provider -> DiagnosticsManager.dump((DiagnosticsProvider)provider, (Log)log, stringJoiner::add));
        });
    }

    private void dumpDatabaseDiagnostics(Database database, Log log, boolean checkStatus) {
        this.dumpAsSingleMessage(log, stringJoiner -> {
            this.dumpDatabaseSectionName(database, stringJoiner::add);
            if (checkStatus) {
                DbmsDiagnosticsManager.logDatabaseStatus(database, stringJoiner::add);
                if (!database.isStarted()) {
                    return;
                }
            }
            Dependencies databaseResolver = database.getDependencyResolver();
            DbmsInfo dbmsInfo = (DbmsInfo)((Object)((Object)databaseResolver.resolveDependency(DbmsInfo.class)));
            FileSystemAbstraction fs = (FileSystemAbstraction)databaseResolver.resolveDependency(FileSystemAbstraction.class);
            StorageEngineFactory storageEngineFactory = (StorageEngineFactory)databaseResolver.resolveDependency(StorageEngineFactory.class);
            StorageEngine storageEngine = (StorageEngine)databaseResolver.resolveDependency(StorageEngine.class);
            DiagnosticsManager.dump((DiagnosticsProvider)new VersionDiagnostics(dbmsInfo, database.getStoreId()), (Log)log, stringJoiner::add);
            DiagnosticsManager.dump((DiagnosticsProvider)new StoreFilesDiagnostics(storageEngineFactory, fs, database.getDatabaseLayout()), (Log)log, stringJoiner::add);
            DiagnosticsManager.dump((DiagnosticsProvider)new TransactionRangeDiagnostics(database), (Log)log, stringJoiner::add);
            storageEngine.dumpDiagnostics(log, stringJoiner::add);
        });
    }

    private void dumpAsSingleMessage(Log log, Consumer<StringJoiner> dumpFunction) {
        if (log == NullLog.getInstance()) {
            return;
        }
        StringJoiner message = new StringJoiner(System.lineSeparator() + " ".repeat(64), System.lineSeparator() + " ".repeat(64), "");
        dumpFunction.accept(message);
        log.info(message.toString());
    }

    private static void logDatabaseStatus(Database database, DiagnosticsLogger log) {
        log.log(String.format("Database is %s.", database.isStarted() ? "started" : "stopped"));
    }

    private void dumpDatabaseSectionName(Database database, DiagnosticsLogger log) {
        DiagnosticsManager.section((DiagnosticsLogger)log, (String)("Database: " + database.getNamedDatabaseId().name()));
    }

    private DatabaseManager<?> getDatabaseManager() {
        return (DatabaseManager)this.dependencies.resolveDependency(DatabaseManager.class);
    }
}

