/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.util.EagerDegrees;
import org.neo4j.storageengine.util.SingleDegree;

class DefaultNodeCursor
extends TraceableCursor
implements NodeCursor {
    Read read;
    boolean checkHasChanges;
    boolean hasChanges;
    private LongIterator addedNodes;
    StorageNodeCursor storeCursor;
    private StorageNodeCursor securityStoreCursor;
    private long currentAddedInTx;
    private long single;
    private AccessMode accessMode;
    private final CursorPool<DefaultNodeCursor> pool;

    DefaultNodeCursor(CursorPool<DefaultNodeCursor> pool, StorageNodeCursor storeCursor, StorageNodeCursor securityStoreCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
        this.securityStoreCursor = securityStoreCursor;
    }

    void scan(Read read) {
        this.storeCursor.scan();
        this.read = read;
        this.single = -1L;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        if (this.tracer != null) {
            this.tracer.onAllNodesScan();
        }
    }

    boolean scanBatch(Read read, AllNodeScan scan, int sizeHint, LongIterator addedNodes, boolean hasChanges) {
        this.read = read;
        this.single = -1L;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = false;
        this.hasChanges = hasChanges;
        this.addedNodes = addedNodes;
        boolean scanBatch = this.storeCursor.scanBatch((Scan)scan, sizeHint);
        return addedNodes.hasNext() || scanBatch;
    }

    void single(long reference, Read read) {
        this.storeCursor.single(reference);
        this.read = read;
        this.single = reference;
        this.currentAddedInTx = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
    }

    public long nodeReference() {
        if (this.currentAddedInTx != -1L) {
            return this.currentAddedInTx;
        }
        return this.storeCursor.entityReference();
    }

    public TokenSet labels() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.read.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            long[] longs = this.storeCursor.labels();
            LongHashSet labels = new LongHashSet();
            for (long labelToken : longs) {
                labels.add(labelToken);
            }
            return Labels.from((LongSet)txState.augmentLabels((MutableLongSet)labels, txState.getNodeState(this.storeCursor.entityReference())));
        }
        return Labels.from(this.storeCursor.labels());
    }

    public TokenSet labelsIgnoringTxStateSetRemove() {
        if (this.currentAddedInTx != -1L) {
            TransactionState txState = this.read.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInTx).getAdded());
        }
        return Labels.from(this.storeCursor.labels());
    }

    public boolean hasLabel(int label) {
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            LongDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.getAdded().contains((long)label)) {
                return true;
            }
            if (diffSets.getRemoved().contains((long)label)) {
                return false;
            }
        }
        return this.storeCursor.hasLabel(label);
    }

    public void relationships(RelationshipTraversalCursor cursor, RelationshipSelection selection) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this, selection, this.read);
    }

    public void properties(PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(this.nodeReference(), this.propertiesReference(), this.read, this.read);
    }

    public long relationshipsReference() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.relationshipsReference();
    }

    public long propertiesReference() {
        return this.currentAddedInTx != -1L ? -1L : this.storeCursor.propertiesReference();
    }

    public boolean supportsFastDegreeLookup() {
        return this.currentAddedInTx == -1L && this.storeCursor.supportsFastDegreeLookup();
    }

    public int[] relationshipTypes() {
        MutableIntSet types;
        boolean hasChanges = this.hasChanges();
        NodeState nodeTxState = hasChanges ? this.read.txState().getNodeState(this.nodeReference()) : null;
        int[] storedTypes = this.currentAddedInTx == -1L ? this.storeCursor.relationshipTypes() : null;
        MutableIntSet mutableIntSet = types = storedTypes != null ? IntSets.mutable.of(storedTypes) : IntSets.mutable.empty();
        if (nodeTxState != null) {
            types.addAll(nodeTxState.getAddedRelationshipTypes());
        }
        return types.toArray();
    }

    public Degrees degrees(RelationshipSelection selection) {
        EagerDegrees degrees = new EagerDegrees();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees;
    }

    public int degree(RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees.getTotal();
    }

    private void fillDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        NodeState nodeTxState;
        boolean hasChanges = this.hasChanges();
        NodeState nodeState = nodeTxState = hasChanges ? this.read.txState().getNodeState(this.nodeReference()) : null;
        if (this.currentAddedInTx == -1L) {
            if (this.accessMode.allowsTraverseAllRelTypes() && this.accessMode.allowsTraverseAllLabels()) {
                this.storeCursor.degrees(selection, degrees, true);
            } else {
                this.storeCursor.degrees((RelationshipSelection)new SecureRelationshipSelection(selection), degrees, false);
            }
        }
        if (nodeTxState != null) {
            IntIterator txTypes = nodeTxState.getAddedAndRemovedRelationshipTypes().intIterator();
            while (txTypes.hasNext()) {
                int type = txTypes.next();
                if (!selection.test(type)) continue;
                int outgoing = selection.test(RelationshipDirection.OUTGOING) ? nodeTxState.augmentDegree(RelationshipDirection.OUTGOING, 0, type) : 0;
                int incoming = selection.test(RelationshipDirection.INCOMING) ? nodeTxState.augmentDegree(RelationshipDirection.INCOMING, 0, type) : 0;
                int loop = selection.test(RelationshipDirection.LOOP) ? nodeTxState.augmentDegree(RelationshipDirection.LOOP, 0, type) : 0;
                degrees.add(type, outgoing, incoming, loop);
            }
        }
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            if (this.addedNodes.hasNext()) {
                this.currentAddedInTx = this.addedNodes.next();
                if (this.tracer != null) {
                    this.tracer.onNode(this.nodeReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (this.storeCursor.next()) {
            boolean skip = hasChanges && this.read.txState().nodeIsDeletedInThisTx(this.storeCursor.entityReference());
            if (skip || !this.allowsTraverse()) continue;
            if (this.tracer != null) {
                this.tracer.onNode(this.nodeReference());
            }
            return true;
        }
        return false;
    }

    boolean allowsTraverse() {
        if (this.accessMode == null) {
            this.accessMode = this.read.ktx.securityContext().mode();
        }
        return this.accessMode.allowsTraverseAllLabels() || this.accessMode.allowsTraverseNode(this.storeCursor.labels());
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.checkHasChanges = true;
            this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
            this.storeCursor.reset();
            this.securityStoreCursor.reset();
            this.accessMode = null;
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.read == null;
    }

    boolean hasChanges() {
        if (this.checkHasChanges) {
            this.computeHasChanges();
        }
        return this.hasChanges;
    }

    private void computeHasChanges() {
        this.checkHasChanges = false;
        this.hasChanges = this.read.hasTxStateWithChanges();
        if (this.hasChanges) {
            this.addedNodes = this.single != -1L ? (this.read.txState().nodeIsAddedInThisTx(this.single) ? PrimitiveLongCollections.single((long)this.single) : ImmutableEmptyLongIterator.INSTANCE) : this.read.txState().addedAndRemovedNodes().getAdded().freeze().longIterator();
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeCursor[closed state]";
        }
        return "NodeCursor[id=" + this.nodeReference() + ", " + this.storeCursor + "]";
    }

    void release() {
        this.storeCursor.close();
        this.securityStoreCursor.close();
    }

    private class SecureRelationshipSelection
    extends RelationshipSelection {
        private final RelationshipSelection inner;

        SecureRelationshipSelection(RelationshipSelection selection) {
            this.inner = selection;
        }

        public boolean test(int type, long sourceReference, long targetReference) {
            if (DefaultNodeCursor.this.accessMode.allowsTraverseRelType(type)) {
                if (sourceReference == targetReference) {
                    return this.inner.test(type);
                }
                long otherReference = sourceReference == DefaultNodeCursor.this.nodeReference() ? targetReference : sourceReference;
                DefaultNodeCursor.this.securityStoreCursor.single(otherReference);
                return DefaultNodeCursor.this.securityStoreCursor.next() && DefaultNodeCursor.this.accessMode.allowsTraverseNode(DefaultNodeCursor.this.securityStoreCursor.labels()) && this.inner.test(type);
            }
            return false;
        }

        public boolean test(int type) {
            return this.inner.test(type);
        }

        public boolean test(RelationshipDirection direction) {
            return this.inner.test(direction);
        }

        public Direction direction() {
            return this.inner.direction();
        }

        public int numberOfCriteria() {
            return this.inner.numberOfCriteria();
        }

        public RelationshipSelection.Criterion criterion(int index) {
            return this.inner.criterion(index);
        }

        public boolean test(int type, RelationshipDirection direction) {
            return this.inner.test(type, direction);
        }

        public boolean isTypeLimited() {
            return this.inner.isTypeLimited();
        }

        public LongIterator addedRelationship(NodeState transactionState) {
            return this.inner.addedRelationship(transactionState);
        }
    }
}

