/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import org.neo4j.internal.id.IdController;
import org.neo4j.kernel.api.KernelTransactionHandle;

public class KernelTransactionsSnapshot
implements IdController.ConditionSnapshot {
    private Tx relevantTransactions;

    KernelTransactionsSnapshot(Set<KernelTransactionHandle> allTransactions) {
        Tx head = null;
        for (KernelTransactionHandle tx : allTransactions) {
            if (!tx.isOpen()) continue;
            Tx current = new Tx(tx);
            if (head != null) {
                current.next = head;
                head = current;
                continue;
            }
            head = current;
        }
        this.relevantTransactions = head;
    }

    public boolean conditionMet() {
        while (this.relevantTransactions != null) {
            if (!this.relevantTransactions.haveClosed()) {
                return false;
            }
            this.relevantTransactions = this.relevantTransactions.next;
        }
        return true;
    }

    private static class Tx {
        private final KernelTransactionHandle transaction;
        private Tx next;

        Tx(KernelTransactionHandle tx) {
            this.transaction = tx;
        }

        boolean haveClosed() {
            return !this.transaction.isOpen();
        }
    }
}

