/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

@RecoveryExtension
public class FulltextIndexProviderFactory
extends ExtensionFactory<Dependencies> {
    private static final String KEY = "fulltext";
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("fulltext", "1.0");

    public FulltextIndexProviderFactory() {
        super(ExtensionType.DATABASE, KEY);
    }

    private static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File storeDir) {
        return IndexDirectoryStructure.directoriesByProvider((File)storeDir);
    }

    @Override
    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        Config config = dependencies.getConfig();
        boolean ephemeral = (Boolean)config.get(GraphDatabaseInternalSettings.ephemeral_lucene);
        FileSystemAbstraction fileSystemAbstraction = dependencies.fileSystem();
        DirectoryFactory directoryFactory = DirectoryFactory.directoryFactory((boolean)ephemeral);
        OperationalMode operationalMode = context.dbmsInfo().operationalMode;
        boolean isSingleInstance = operationalMode == OperationalMode.SINGLE;
        JobScheduler scheduler = dependencies.scheduler();
        IndexDirectoryStructure.Factory directoryStructureFactory = FulltextIndexProviderFactory.subProviderDirectoryStructure(context.directory());
        TokenHolders tokenHolders = dependencies.tokenHolders();
        Log log = dependencies.getLogService().getInternalLog(FulltextIndexProvider.class);
        return new FulltextIndexProvider(DESCRIPTOR, directoryStructureFactory, fileSystemAbstraction, config, tokenHolders, directoryFactory, isSingleInstance, scheduler, log);
    }

    public static interface Dependencies {
        public Config getConfig();

        public FileSystemAbstraction fileSystem();

        public JobScheduler scheduler();

        public TokenHolders tokenHolders();

        public LogService getLogService();
    }
}

