/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;

public class RelationshipChangesForNode {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipChangesForNode.class);
    private final DiffStrategy diffStrategy;
    private final MemoryTracker memoryTracker;
    private MutableIntObjectMap<MutableLongSet> outgoing;
    private MutableIntObjectMap<MutableLongSet> incoming;
    private MutableIntObjectMap<MutableLongSet> loops;

    static RelationshipChangesForNode createRelationshipChangesForNode(DiffStrategy diffStrategy, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new RelationshipChangesForNode(diffStrategy, memoryTracker);
    }

    private RelationshipChangesForNode(DiffStrategy diffStrategy, MemoryTracker memoryTracker) {
        this.diffStrategy = diffStrategy;
        this.memoryTracker = memoryTracker;
    }

    public void addRelationship(long relId, int typeId, RelationshipDirection direction) {
        MutableIntObjectMap<MutableLongSet> relTypeToRelsMap = this.getTypeToRelMapForDirection(direction);
        MutableLongSet rels = (MutableLongSet)relTypeToRelsMap.getIfAbsentPut(typeId, (Function0 & Serializable)() -> HeapTrackingCollections.newLongSet((MemoryTracker)this.memoryTracker));
        rels.add(relId);
    }

    public boolean removeRelationship(long relId, int typeId, RelationshipDirection direction) {
        MutableIntObjectMap<MutableLongSet> relTypeToRelsMap = this.getTypeToRelMapForDirection(direction);
        MutableLongSet rels = (MutableLongSet)relTypeToRelsMap.get(typeId);
        if (rels != null && rels.remove(relId)) {
            if (rels.isEmpty()) {
                relTypeToRelsMap.remove(typeId);
            }
            return true;
        }
        return false;
    }

    public int augmentDegree(RelationshipDirection direction, int degree, int typeId) {
        switch (direction) {
            case INCOMING: {
                return this.diffStrategy.augmentDegree(degree, this.degreeDiff(typeId, this.incoming));
            }
            case OUTGOING: {
                return this.diffStrategy.augmentDegree(degree, this.degreeDiff(typeId, this.outgoing));
            }
            case LOOP: {
                return this.diffStrategy.augmentDegree(degree, this.degreeDiff(typeId, this.loops));
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    private int degreeDiff(int type, MutableIntObjectMap<MutableLongSet> map) {
        MutableLongSet set;
        if (map != null && (set = (MutableLongSet)map.get(type)) != null) {
            return set.size();
        }
        return 0;
    }

    public void clear() {
        if (this.outgoing != null) {
            this.outgoing.clear();
        }
        if (this.incoming != null) {
            this.incoming.clear();
        }
    }

    private MutableIntObjectMap<MutableLongSet> outgoing() {
        if (this.outgoing == null) {
            this.outgoing = HeapTrackingCollections.newIntObjectHashMap((MemoryTracker)this.memoryTracker);
        }
        return this.outgoing;
    }

    private MutableIntObjectMap<MutableLongSet> incoming() {
        if (this.incoming == null) {
            this.incoming = HeapTrackingCollections.newIntObjectHashMap((MemoryTracker)this.memoryTracker);
        }
        return this.incoming;
    }

    private MutableIntObjectMap<MutableLongSet> loops() {
        if (this.loops == null) {
            this.loops = HeapTrackingCollections.newIntObjectHashMap((MemoryTracker)this.memoryTracker);
        }
        return this.loops;
    }

    private MutableIntObjectMap<MutableLongSet> getTypeToRelMapForDirection(RelationshipDirection direction) {
        MutableIntObjectMap<MutableLongSet> relTypeToRelsMap;
        switch (direction) {
            case INCOMING: {
                relTypeToRelsMap = this.incoming();
                break;
            }
            case OUTGOING: {
                relTypeToRelsMap = this.outgoing();
                break;
            }
            case LOOP: {
                relTypeToRelsMap = this.loops();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction: " + direction);
            }
        }
        return relTypeToRelsMap;
    }

    public LongIterator getRelationships() {
        return this.nonEmptyConcat(RelationshipChangesForNode.primitiveIds(this.incoming), RelationshipChangesForNode.primitiveIds(this.outgoing), RelationshipChangesForNode.primitiveIds(this.loops));
    }

    private LongIterator nonEmptyConcat(LongIterator ... primitiveIds) {
        return PrimitiveLongCollections.concat((Iterator)Iterators.filter(ids -> ids != ImmutableEmptyLongIterator.INSTANCE, (Iterator)Iterators.iterator((Object[])primitiveIds)));
    }

    public LongIterator getRelationships(Direction direction) {
        switch (direction) {
            case INCOMING: {
                return this.incoming == null && this.loops == null ? ImmutableEmptyLongIterator.INSTANCE : this.nonEmptyConcat(RelationshipChangesForNode.primitiveIds(this.incoming), RelationshipChangesForNode.primitiveIds(this.loops));
            }
            case OUTGOING: {
                return this.outgoing == null && this.loops == null ? ImmutableEmptyLongIterator.INSTANCE : this.nonEmptyConcat(RelationshipChangesForNode.primitiveIds(this.outgoing), RelationshipChangesForNode.primitiveIds(this.loops));
            }
            case BOTH: {
                return this.getRelationships();
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    public LongIterator getRelationships(Direction direction, int type) {
        switch (direction) {
            case INCOMING: {
                return this.incoming == null && this.loops == null ? ImmutableEmptyLongIterator.INSTANCE : this.nonEmptyConcat(RelationshipChangesForNode.primitiveIdsByType(this.incoming, type), RelationshipChangesForNode.primitiveIdsByType(this.loops, type));
            }
            case OUTGOING: {
                return this.outgoing == null && this.loops == null ? ImmutableEmptyLongIterator.INSTANCE : this.nonEmptyConcat(RelationshipChangesForNode.primitiveIdsByType(this.outgoing, type), RelationshipChangesForNode.primitiveIdsByType(this.loops, type));
            }
            case BOTH: {
                return this.nonEmptyConcat(RelationshipChangesForNode.primitiveIdsByType(this.outgoing, type), RelationshipChangesForNode.primitiveIdsByType(this.incoming, type), RelationshipChangesForNode.primitiveIdsByType(this.loops, type));
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    public IntSet relationshipTypes() {
        MutableIntSet types = IntSets.mutable.empty();
        this.addRelationshipTypes(types, this.outgoing);
        this.addRelationshipTypes(types, this.incoming);
        this.addRelationshipTypes(types, this.loops);
        return types;
    }

    private void addRelationshipTypes(MutableIntSet types, MutableIntObjectMap<MutableLongSet> relationships) {
        if (relationships != null) {
            types.addAll((IntIterable)relationships.keySet());
        }
    }

    private static LongIterator primitiveIds(IntObjectMap<MutableLongSet> map) {
        if (map == null) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
        int size = Math.toIntExact(map.sumOfInt(PrimitiveIterable::size));
        LongHashSet ids = new LongHashSet(size);
        map.values().forEach(arg_0 -> ((MutableLongSet)ids).addAll(arg_0));
        return ids.longIterator();
    }

    private static LongIterator primitiveIdsByType(IntObjectMap<MutableLongSet> map, int type) {
        if (map == null) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
        LongSet relationships = (LongSet)map.get(type);
        return relationships == null ? ImmutableEmptyLongIterator.INSTANCE : relationships.freeze().longIterator();
    }

    public static enum DiffStrategy {
        REMOVE{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree - diff;
            }
        }
        ,
        ADD{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree + diff;
            }
        };


        abstract int augmentDegree(int var1, int var2);
    }
}

