/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.LogVersionRepository;

class TransactionLogFile
extends LifecycleAdapter
implements LogFile {
    private static final String TRANSACTION_LOG_FILE_ROTATION_TAG = "transactionLogFileRotation";
    private final AtomicLong rotateAtSize;
    private final LogFiles logFiles;
    private final TransactionLogFilesContext context;
    private final LogVersionBridge readerLogVersionBridge;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private volatile PhysicalLogVersionedStoreChannel channel;
    private PositionAwarePhysicalFlushableChecksumChannel writer;
    private LogVersionRepository logVersionRepository;

    TransactionLogFile(LogFiles logFiles, TransactionLogFilesContext context) {
        this.rotateAtSize = context.getRotationThreshold();
        this.context = context;
        this.logFiles = logFiles;
        this.readerLogVersionBridge = new ReaderLogVersionBridge(logFiles);
        this.pageCacheTracer = context.getDatabaseTracers().getPageCacheTracer();
        this.memoryTracker = context.getMemoryTracker();
    }

    public void init() throws IOException {
        this.logVersionRepository = this.context.getLogVersionRepository();
    }

    public void start() throws IOException {
        long currentLogVersion = this.logVersionRepository.getCurrentLogVersion();
        this.channel = this.logFiles.createLogChannelForVersion(currentLogVersion, this.context::getLastCommittedTransactionId);
        this.seekChannelPosition(currentLogVersion);
        this.writer = new PositionAwarePhysicalFlushableChecksumChannel(this.channel, (ScopedBuffer)new NativeScopedBuffer(TransactionLogFile.calculateLogBufferSize(), this.memoryTracker));
    }

    private void seekChannelPosition(long currentLogVersion) throws IOException {
        LogPosition position;
        this.jumpToTheLastClosedTxPosition(currentLogVersion);
        try {
            position = this.scanToEndOfLastLogEntry();
        }
        catch (Exception e) {
            this.jumpToLogStart(currentLogVersion);
            try {
                position = this.scanToEndOfLastLogEntry();
            }
            catch (Exception exception) {
                exception.addSuppressed(e);
                throw exception;
            }
        }
        this.channel.position(position.getByteOffset());
    }

    private LogPosition scanToEndOfLastLogEntry() throws IOException {
        try (ReadAheadLogChannel readAheadLogChannel = new ReadAheadLogChannel(new UncloseableChannel(this.channel), this.memoryTracker);){
            LogEntry entry;
            LogEntryReader logEntryReader = this.context.getLogEntryReader();
            while ((entry = logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)readAheadLogChannel)) != null) {
            }
            LogPosition logPosition = logEntryReader.lastPosition();
            return logPosition;
        }
    }

    private void jumpToTheLastClosedTxPosition(long currentLogVersion) throws IOException {
        LogPosition logPosition = this.context.getLastClosedTransactionPosition();
        long lastTxOffset = logPosition.getByteOffset();
        long lastTxLogVersion = logPosition.getLogVersion();
        long headerSize = this.logFiles.extractHeader(currentLogVersion).getStartPosition().getByteOffset();
        if (lastTxOffset < headerSize || this.channel.size() < lastTxOffset) {
            return;
        }
        if (lastTxLogVersion == currentLogVersion) {
            this.channel.position(lastTxOffset);
        }
    }

    private void jumpToLogStart(long currentLogVersion) throws IOException {
        long headerSize = this.logFiles.extractHeader(currentLogVersion).getStartPosition().getByteOffset();
        this.channel.position(headerSize);
    }

    public void shutdown() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new PositionAwarePhysicalFlushableChecksumChannel[]{this.writer});
    }

    @Override
    public boolean rotationNeeded() {
        return this.channel.position() >= this.rotateAtSize.get();
    }

    @Override
    public synchronized File rotate() throws IOException {
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer(TRANSACTION_LOG_FILE_ROTATION_TAG);){
            this.channel = this.rotate(this.channel, cursorTracer);
            this.writer.setChannel(this.channel);
            File file = this.channel.getFile();
            return file;
        }
    }

    private PhysicalLogVersionedStoreChannel rotate(LogVersionedStoreChannel currentLog, PageCursorTracer cursorTracer) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetVersion(cursorTracer);
        this.writer.prepareForFlush().flush();
        currentLog.truncate(currentLog.position());
        PhysicalLogVersionedStoreChannel newLog = this.logFiles.createLogChannelForVersion(newLogVersion, this.context::committingTransactionId);
        currentLog.close();
        return newLog;
    }

    @Override
    public FlushablePositionAwareChecksumChannel getWriter() {
        return this.writer;
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position) throws IOException {
        return this.getReader(position, this.readerLogVersionBridge);
    }

    @Override
    public ReadableLogChannel getReader(LogPosition position, LogVersionBridge logVersionBridge) throws IOException {
        PhysicalLogVersionedStoreChannel logChannel = this.logFiles.openForVersion(position.getLogVersion());
        logChannel.position(position.getByteOffset());
        return new ReadAheadLogChannel((LogVersionedStoreChannel)logChannel, logVersionBridge, this.memoryTracker);
    }

    @Override
    public void accept(LogFile.LogFileVisitor visitor, LogPosition startingFromPosition) throws IOException {
        try (ReadableLogChannel reader = this.getReader(startingFromPosition);){
            visitor.visit((ReadableClosablePositionAwareChecksumChannel)reader);
        }
    }

    private static int calculateLogBufferSize() {
        return (int)ByteUnit.kibiBytes((long)(Math.min(Runtime.getRuntime().availableProcessors() / 4 + 1, 8) * 512));
    }

    private static class UncloseableChannel
    extends DelegatingStoreChannel<LogVersionedStoreChannel>
    implements LogVersionedStoreChannel {
        UncloseableChannel(LogVersionedStoreChannel channel) {
            super((StoreChannel)channel);
        }

        public long getVersion() {
            return ((LogVersionedStoreChannel)this.delegate).getVersion();
        }

        public byte getLogFormatVersion() {
            return ((LogVersionedStoreChannel)this.delegate).getLogFormatVersion();
        }

        public void close() throws IOException {
        }
    }
}

