/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;

public class FusionIndexSampler
implements IndexSampler {
    private final Iterable<IndexSampler> samplers;

    public FusionIndexSampler(Iterable<IndexSampler> samplers) {
        this.samplers = samplers;
    }

    public IndexSample sampleIndex(PageCursorTracer cursorTracer) throws IndexNotFoundKernelException {
        ArrayList<IndexSample> samples = new ArrayList<IndexSample>();
        Exception exception = null;
        for (IndexSampler sampler : this.samplers) {
            try {
                samples.add(sampler.sampleIndex(cursorTracer));
            }
            catch (RuntimeException | IndexNotFoundKernelException e) {
                exception = (Exception)Exceptions.chain(exception, (Throwable)e);
            }
        }
        if (exception != null) {
            Exceptions.throwIfUnchecked(exception);
            Exceptions.throwIfInstanceOf(exception, IndexNotFoundKernelException.class);
            throw new RuntimeException(exception);
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    public static IndexSample combineSamples(Iterable<IndexSample> samples) {
        long indexSize = 0L;
        long uniqueValues = 0L;
        long sampleSize = 0L;
        for (IndexSample sample : samples) {
            indexSize += sample.indexSize();
            uniqueValues += sample.uniqueValues();
            sampleSize += sample.sampleSize();
        }
        return new IndexSample(indexSize, uniqueValues, sampleSize);
    }

    public void close() {
        IOUtils.closeAllSilently((Collection)Iterables.asCollection(this.samplers));
    }
}

