/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.LongLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongLongMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.LinearProbeLongLongHashMap;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapMemoryAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class LinearProbeLongLongHashMapTest {
    @Inject
    private RandomRule rnd;
    private final CachingOffHeapBlockAllocator blockAllocator = new CachingOffHeapBlockAllocator();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final MemoryAllocator memoryAllocator = new OffHeapMemoryAllocator((OffHeapBlockAllocator)this.blockAllocator);
    private LinearProbeLongLongHashMap map = this.newMap();

    LinearProbeLongLongHashMapTest() {
    }

    private LinearProbeLongLongHashMap newMap() {
        return new LinearProbeLongLongHashMap(this.memoryAllocator, this.memoryTracker);
    }

    @AfterEach
    void tearDown() {
        this.map.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedNativeMemory(), (String)"Leaking memory");
        this.blockAllocator.release();
    }

    @Test
    void putGetRemove() {
        this.map.put(0L, 10L);
        this.map.put(1L, 11L);
        this.map.put(2L, 12L);
        Assertions.assertEquals((long)10L, (long)this.map.get(0L));
        Assertions.assertEquals((long)11L, (long)this.map.get(1L));
        Assertions.assertEquals((long)12L, (long)this.map.get(2L));
        Assertions.assertEquals((long)0L, (long)this.map.get(3L));
        this.map.remove(1L);
        this.map.remove(2L);
        this.map.remove(0L);
        Assertions.assertEquals((long)0L, (long)this.map.get(0L));
        Assertions.assertEquals((long)0L, (long)this.map.get(1L));
        Assertions.assertEquals((long)0L, (long)this.map.get(2L));
    }

    @Test
    void putAll() {
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        Assertions.assertEquals((int)3, (int)this.map.size());
        Assertions.assertEquals((long)10L, (long)this.map.get(0L));
        Assertions.assertEquals((long)11L, (long)this.map.get(1L));
        Assertions.assertEquals((long)12L, (long)this.map.get(2L));
    }

    @Test
    void getIfAbsent() {
        Assertions.assertEquals((long)-1L, (long)this.map.getIfAbsent(0L, -1L));
        Assertions.assertEquals((long)-1L, (long)this.map.getIfAbsent(1L, -1L));
        Assertions.assertEquals((long)-1L, (long)this.map.getIfAbsent(2L, -1L));
        Assertions.assertEquals((long)-1L, (long)this.map.getIfAbsent(3L, -1L));
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsent(0L, -1L));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsent(1L, -1L));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsent(2L, -1L));
        Assertions.assertEquals((long)-1L, (long)this.map.getIfAbsent(3L, -1L));
    }

    @Test
    void getIfAbsentPut() {
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPut(0L, 10L));
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPut(0L, 100L));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPut(1L, 11L));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPut(1L, 110L));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPut(2L, 12L));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPut(2L, 120L));
    }

    @Test
    void getIfAbsentPut_Supplier() {
        LongFunction0 supplier = (LongFunction0)Mockito.mock(LongFunction0.class);
        ((LongFunction0)Mockito.doReturn((Object)10L, (Object[])new Object[]{11L, 12L}).when((Object)supplier)).value();
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPut(0L, supplier));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPut(1L, supplier));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPut(2L, supplier));
        ((LongFunction0)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)3))).value();
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPut(0L, supplier));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPut(1L, supplier));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPut(2L, supplier));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{supplier});
    }

    @Test
    void getIfAbsentPutWithKey() {
        LongToLongFunction function = (LongToLongFunction)Mockito.spy((Object)new LongToLongFunction(){

            public long valueOf(long x) {
                return 10L + x;
            }
        });
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPutWithKey(0L, function));
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPutWithKey(0L, function));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPutWithKey(1L, function));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPutWithKey(1L, function));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPutWithKey(2L, function));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPutWithKey(2L, function));
        ((LongToLongFunction)Mockito.verify((Object)function)).valueOf(ArgumentMatchers.eq((long)0L));
        ((LongToLongFunction)Mockito.verify((Object)function)).valueOf(ArgumentMatchers.eq((long)1L));
        ((LongToLongFunction)Mockito.verify((Object)function)).valueOf(ArgumentMatchers.eq((long)2L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{function});
    }

    @Test
    void getIfAbsentPutWith() {
        LongFunction function = (LongFunction)Mockito.spy((Object)new LongFunction<String>(){

            public long longValueOf(String s) {
                return Long.valueOf(s);
            }
        });
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPutWith(0L, function, (Object)"10"));
        Assertions.assertEquals((long)10L, (long)this.map.getIfAbsentPutWith(0L, function, (Object)"10"));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPutWith(1L, function, (Object)"11"));
        Assertions.assertEquals((long)11L, (long)this.map.getIfAbsentPutWith(1L, function, (Object)"11"));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPutWith(2L, function, (Object)"12"));
        Assertions.assertEquals((long)12L, (long)this.map.getIfAbsentPutWith(2L, function, (Object)"12"));
        ((LongFunction)Mockito.verify((Object)function)).longValueOf((Object)((String)ArgumentMatchers.eq((Object)"10")));
        ((LongFunction)Mockito.verify((Object)function)).longValueOf((Object)((String)ArgumentMatchers.eq((Object)"11")));
        ((LongFunction)Mockito.verify((Object)function)).longValueOf((Object)((String)ArgumentMatchers.eq((Object)"12")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{function});
    }

    @Test
    void getOrThrow() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.map.getOrThrow(0L));
        Assertions.assertThrows(IllegalStateException.class, () -> this.map.getOrThrow(1L));
        Assertions.assertThrows(IllegalStateException.class, () -> this.map.getOrThrow(2L));
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        Assertions.assertEquals((long)10L, (long)this.map.getOrThrow(0L));
        Assertions.assertEquals((long)11L, (long)this.map.getOrThrow(1L));
        Assertions.assertEquals((long)12L, (long)this.map.getOrThrow(2L));
    }

    @Test
    void putOverwrite() {
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        Assertions.assertEquals((long)10L, (long)this.map.get(0L));
        Assertions.assertEquals((long)11L, (long)this.map.get(1L));
        Assertions.assertEquals((long)12L, (long)this.map.get(2L));
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)20L, (long)1L, (long)21L, (long)2L, (long)22L));
        Assertions.assertEquals((long)20L, (long)this.map.get(0L));
        Assertions.assertEquals((long)21L, (long)this.map.get(1L));
        Assertions.assertEquals((long)22L, (long)this.map.get(2L));
    }

    @Test
    void size() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put(0L, 10L);
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.put(1L, 11L);
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.put(2L, 12L);
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.put(0L, 20L);
        this.map.put(1L, 20L);
        this.map.put(2L, 20L);
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.remove(0L);
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.remove(1L);
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.remove(2L);
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    void containsKey() {
        Assertions.assertFalse((boolean)this.map.containsKey(0L));
        Assertions.assertFalse((boolean)this.map.containsKey(1L));
        Assertions.assertFalse((boolean)this.map.containsKey(2L));
        this.map.put(0L, 10L);
        Assertions.assertTrue((boolean)this.map.containsKey(0L));
        this.map.put(1L, 11L);
        Assertions.assertTrue((boolean)this.map.containsKey(1L));
        this.map.put(2L, 12L);
        Assertions.assertTrue((boolean)this.map.containsKey(2L));
        this.map.remove(0L);
        Assertions.assertFalse((boolean)this.map.containsKey(0L));
        this.map.remove(1L);
        Assertions.assertFalse((boolean)this.map.containsKey(1L));
        this.map.remove(2L);
        Assertions.assertFalse((boolean)this.map.containsKey(2L));
    }

    @Test
    void containsValue() {
        Assertions.assertFalse((boolean)this.map.containsValue(10L));
        Assertions.assertFalse((boolean)this.map.containsValue(11L));
        Assertions.assertFalse((boolean)this.map.containsValue(12L));
        this.map.put(0L, 10L);
        Assertions.assertTrue((boolean)this.map.containsValue(10L));
        this.map.put(1L, 11L);
        Assertions.assertTrue((boolean)this.map.containsValue(11L));
        this.map.put(2L, 12L);
        Assertions.assertTrue((boolean)this.map.containsValue(12L));
    }

    @Test
    void removeKeyIfAbsent() {
        Assertions.assertEquals((long)10L, (long)this.map.removeKeyIfAbsent(0L, 10L));
        Assertions.assertEquals((long)11L, (long)this.map.removeKeyIfAbsent(1L, 11L));
        Assertions.assertEquals((long)12L, (long)this.map.removeKeyIfAbsent(2L, 12L));
        this.map.put(0L, 10L);
        this.map.put(1L, 11L);
        this.map.put(2L, 12L);
        Assertions.assertEquals((long)10L, (long)this.map.removeKeyIfAbsent(0L, -1L));
        Assertions.assertEquals((long)11L, (long)this.map.removeKeyIfAbsent(1L, -1L));
        Assertions.assertEquals((long)12L, (long)this.map.removeKeyIfAbsent(2L, -1L));
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    void updateValue() {
        this.map.updateValue(0L, 10L, (LongToLongFunction & Serializable)v -> -v);
        this.map.updateValue(1L, 11L, (LongToLongFunction & Serializable)v -> -v);
        this.map.updateValue(2L, 12L, (LongToLongFunction & Serializable)v -> -v);
        Assertions.assertEquals((long)-10L, (long)this.map.get(0L));
        Assertions.assertEquals((long)-11L, (long)this.map.get(1L));
        Assertions.assertEquals((long)-12L, (long)this.map.get(2L));
        this.map.updateValue(0L, 0L, (LongToLongFunction & Serializable)v -> -v);
        this.map.updateValue(1L, 0L, (LongToLongFunction & Serializable)v -> -v);
        this.map.updateValue(2L, 0L, (LongToLongFunction & Serializable)v -> -v);
        Assertions.assertEquals((long)10L, (long)this.map.get(0L));
        Assertions.assertEquals((long)11L, (long)this.map.get(1L));
        Assertions.assertEquals((long)12L, (long)this.map.get(2L));
        Assertions.assertEquals((int)3, (int)this.map.size());
    }

    @Test
    void addToValue() {
        Assertions.assertEquals((long)10L, (long)this.map.addToValue(0L, 10L));
        Assertions.assertEquals((long)11L, (long)this.map.addToValue(1L, 11L));
        Assertions.assertEquals((long)12L, (long)this.map.addToValue(2L, 12L));
        Assertions.assertEquals((long)110L, (long)this.map.addToValue(0L, 100L));
        Assertions.assertEquals((long)111L, (long)this.map.addToValue(1L, 100L));
        Assertions.assertEquals((long)112L, (long)this.map.addToValue(2L, 100L));
        Assertions.assertEquals((int)3, (int)this.map.size());
    }

    @Test
    void forEachKey() {
        LongProcedure consumer = (LongProcedure)Mockito.mock(LongProcedure.class);
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        this.map.forEachKey(consumer);
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)0L));
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)1L));
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)2L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void forEachValue() {
        LongProcedure consumer = (LongProcedure)Mockito.mock(LongProcedure.class);
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        this.map.forEachValue(consumer);
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)10L));
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)11L));
        ((LongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)12L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void forEachKeyValue() {
        LongLongProcedure consumer = (LongLongProcedure)Mockito.mock(LongLongProcedure.class);
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        this.map.forEachKeyValue(consumer);
        ((LongLongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)10L));
        ((LongLongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((long)11L));
        ((LongLongProcedure)Mockito.verify((Object)consumer)).value(ArgumentMatchers.eq((long)2L), ArgumentMatchers.eq((long)12L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void clear() {
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        Assertions.assertEquals((int)3, (int)this.map.size());
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    void toList() {
        Assertions.assertEquals((int)0, (int)this.map.toList().size());
        this.map.putAll(LinearProbeLongLongHashMapTest.toMap(0L, 1L, 2L, 3L, 4L, 5L));
        Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L}), (Object)this.map.toList().sortThis());
    }

    @Test
    void toArray() {
        Assertions.assertEquals((int)0, (int)this.map.toArray().length);
        this.map.putAll(LinearProbeLongLongHashMapTest.toMap(0L, 1L, 2L, 3L, 4L, 5L));
        Assertions.assertArrayEquals((long[])new long[]{0L, 1L, 2L, 3L, 4L, 5L}, (long[])this.map.toSortedArray());
    }

    @Test
    void keysIterator() {
        ImmutableLongSet keys = LongSets.immutable.of(new long[]{0L, 1L, 2L, 42L});
        keys.forEach((LongProcedure & Serializable)k -> this.map.put(k, k * 10L));
        MutableLongIterator iter = this.map.longIterator();
        LongHashSet found = new LongHashSet();
        while (iter.hasNext()) {
            found.add(iter.next());
        }
        Assertions.assertEquals((Object)keys, (Object)found);
    }

    @Test
    void keysIteratorFailsWhenMapIsClosed() {
        this.map.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)10L, (long)1L, (long)11L, (long)2L, (long)12L));
        MutableLongIterator iter = this.map.longIterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((long)0L, (long)iter.next());
        this.map.close();
        Assertions.assertThrows(ConcurrentModificationException.class, () -> ((MutableLongIterator)iter).hasNext());
        Assertions.assertThrows(ConcurrentModificationException.class, () -> ((MutableLongIterator)iter).next());
    }

    @Test
    void grow() {
        this.map = (LinearProbeLongLongHashMap)Mockito.spy((Object)this.map);
        for (int i = 0; i < 32; ++i) {
            this.map.put((long)(100 + i), (long)i);
        }
        ((LinearProbeLongLongHashMap)Mockito.verify((Object)this.map)).growAndRehash();
    }

    @Test
    void rehashWhenTooManyRemovals() {
        int i;
        this.map = (LinearProbeLongLongHashMap)Mockito.spy((Object)this.map);
        int numOfElements = 16;
        int removalsToTriggerRehashing = 8;
        for (i = 0; i < 16; ++i) {
            this.map.put((long)(100 + i), (long)i);
        }
        Assertions.assertEquals((int)16, (int)this.map.size());
        ((LinearProbeLongLongHashMap)Mockito.verify((Object)this.map, (VerificationMode)Mockito.never())).rehashWithoutGrow();
        ((LinearProbeLongLongHashMap)Mockito.verify((Object)this.map, (VerificationMode)Mockito.never())).growAndRehash();
        for (i = 0; i < 8; ++i) {
            this.map.remove((long)(100 + i));
        }
        Assertions.assertEquals((int)8, (int)this.map.size());
        ((LinearProbeLongLongHashMap)Mockito.verify((Object)this.map)).rehashWithoutGrow();
        ((LinearProbeLongLongHashMap)Mockito.verify((Object)this.map, (VerificationMode)Mockito.never())).growAndRehash();
    }

    @Test
    void randomizedTest() {
        int count = 10000 + this.rnd.nextInt(1000);
        LongLongHashMap m = new LongLongHashMap();
        while (m.size() < count) {
            m.put(this.rnd.nextLong(), this.rnd.nextLong());
        }
        m.forEachKeyValue((LongLongProcedure & Serializable)(k, v) -> {
            Assertions.assertFalse((boolean)this.map.containsKey(k));
            this.map.put(k, v);
            Assertions.assertTrue((boolean)this.map.containsKey(k));
            Assertions.assertEquals((long)v, (long)this.map.get(k));
            Assertions.assertEquals((long)v, (long)this.map.getOrThrow(k));
            Assertions.assertEquals((long)v, (long)this.map.getIfAbsent(k, v * 2L));
            Assertions.assertEquals((long)v, (long)this.map.getIfAbsentPut(k, v * 2L));
            Assertions.assertEquals((long)v, (long)this.map.getIfAbsentPut(k, (LongFunction0 & Serializable)() -> v * 2L));
        });
        Assertions.assertEquals((int)m.size(), (int)this.map.size());
        Assertions.assertTrue((boolean)m.keySet().allSatisfy(arg_0 -> ((LinearProbeLongLongHashMap)this.map).containsKey(arg_0)));
        MutableList toRemove = m.keyValuesView().select((Predicate & Serializable)p -> this.rnd.nextInt(100) < 75).toList().shuffleThis(this.rnd.random());
        toRemove.forEach(p -> {
            long k = p.getOne();
            long v = p.getTwo();
            this.map.updateValue(k, v + 1L, (LongToLongFunction & Serializable)x -> -x);
            Assertions.assertEquals((long)(-v), (long)this.map.get(k));
            this.map.remove(k);
            Assertions.assertEquals((long)(v * 2L), (long)this.map.removeKeyIfAbsent(k, v * 2L));
            Assertions.assertEquals((long)(v * 2L), (long)this.map.getIfAbsent(k, v * 2L));
            Assertions.assertFalse((boolean)this.map.containsKey(k));
            Assertions.assertThrows(IllegalStateException.class, () -> this.map.getOrThrow(k));
            this.map.updateValue(k, v + 42L, (LongToLongFunction & Serializable)x -> -x);
            Assertions.assertEquals((long)(-v - 42L), (long)this.map.get(k));
        });
        toRemove.forEach(p -> this.map.removeKey(p.getOne()));
        Assertions.assertEquals((int)(count - toRemove.size()), (int)this.map.size());
    }

    private static void fill(MutableLongLongMap m, long ... keys) {
        for (long key : keys) {
            m.put(key, System.nanoTime());
        }
    }

    private static LongLongMap toMap(long ... keys) {
        LongLongHashMap m = new LongLongHashMap();
        LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)m, keys);
        return m;
    }

    @Nested
    class IterationConcurrentModification {
        IterationConcurrentModification() {
        }

        @Test
        void put() {
            this.testIteratorsFail(m -> m.put(0L, 0L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.put(1L, 1L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.put(0L, 0L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.put(1L, 1L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.put(2L, 2L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.put(4L, 14L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
        }

        @Test
        void getIfAbsentPut_put() {
            this.testIteratorsFail(m -> m.getIfAbsentPut(0L, 0L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.getIfAbsentPut(1L, 1L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.getIfAbsentPut(4L, 4L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
        }

        @Test
        void getIfAbsentPut_onlyGetNoPut() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, 0L, 1L, 2L, 3L);
            MutableLongIterator keyIter = LinearProbeLongLongHashMapTest.this.map.longIterator();
            Iterator keyValueIter = LinearProbeLongLongHashMapTest.this.map.keyValuesView().iterator();
            LinearProbeLongLongHashMapTest.this.map.getIfAbsentPut(0L, 0L);
            LinearProbeLongLongHashMapTest.this.map.getIfAbsentPut(1L, 1L);
            LinearProbeLongLongHashMapTest.this.map.getIfAbsentPut(2L, 2L);
            Assertions.assertDoesNotThrow(() -> ((MutableLongIterator)keyIter).hasNext());
            Assertions.assertDoesNotThrow(() -> ((MutableLongIterator)keyIter).next());
            Assertions.assertDoesNotThrow(keyValueIter::hasNext);
            Assertions.assertDoesNotThrow(keyValueIter::next);
        }

        @Test
        void remove() {
            this.testIteratorsFail(m -> m.remove(0L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.remove(1L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.remove(0L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.remove(1L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.remove(2L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.remove(4L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
        }

        @Test
        void putAll() {
            this.testIteratorsFail(m -> m.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)0L, (long)0L)), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.putAll((LongLongMap)LongLongHashMap.newWithKeysValues((long)4L, (long)4L)), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.putAll((LongLongMap)LongLongMaps.immutable.empty()), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
        }

        @Test
        void updateValue() {
            this.testIteratorsFail(m -> m.updateValue(0L, 0L, (LongToLongFunction & Serializable)x -> x * 2L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.updateValue(2L, 2L, (LongToLongFunction & Serializable)x -> x * 2L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
            this.testIteratorsFail(m -> m.updateValue(4L, 4L, (LongToLongFunction & Serializable)x -> x * 2L), PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)1L, (long)11L), PrimitiveTuples.pair((long)2L, (long)12L), PrimitiveTuples.pair((long)3L, (long)13L));
        }

        @Test
        void close() {
            this.testIteratorsFail(LinearProbeLongLongHashMap::close, PrimitiveTuples.pair((long)0L, (long)10L), PrimitiveTuples.pair((long)2L, (long)12L));
        }

        private void testIteratorsFail(Consumer<LinearProbeLongLongHashMap> mutator, LongLongPair ... initialValues) {
            LinearProbeLongLongHashMapTest.this.map.clear();
            for (LongLongPair pair : initialValues) {
                LinearProbeLongLongHashMapTest.this.map.putPair(pair);
            }
            MutableLongIterator keysIterator = LinearProbeLongLongHashMapTest.this.map.longIterator();
            Iterator keyValueIterator = LinearProbeLongLongHashMapTest.this.map.keyValuesView().iterator();
            Assertions.assertTrue((boolean)keysIterator.hasNext());
            Assertions.assertDoesNotThrow(() -> ((MutableLongIterator)keysIterator).next());
            Assertions.assertTrue((boolean)keyValueIterator.hasNext());
            Assertions.assertDoesNotThrow(keyValueIterator::next);
            mutator.accept(LinearProbeLongLongHashMapTest.this.map);
            Assertions.assertThrows(ConcurrentModificationException.class, () -> ((MutableLongIterator)keysIterator).hasNext());
            Assertions.assertThrows(ConcurrentModificationException.class, () -> ((MutableLongIterator)keysIterator).next());
            Assertions.assertThrows(ConcurrentModificationException.class, keyValueIterator::hasNext);
            Assertions.assertThrows(ConcurrentModificationException.class, keyValueIterator::next);
        }
    }

    @Nested
    class Collisions {
        private final ImmutableLongList collisions = this.generateKeyCollisions(5);
        private final long a = this.collisions.get(0);
        private final long b = this.collisions.get(1);
        private final long c = this.collisions.get(2);
        private final long d = this.collisions.get(3);
        private final long e = this.collisions.get(4);

        Collisions() {
        }

        private ImmutableLongList generateKeyCollisions(int n) {
            MutableLongList elements;
            long seed = LinearProbeLongLongHashMapTest.this.rnd.nextLong();
            try (LinearProbeLongLongHashMap s = new LinearProbeLongLongHashMap(LinearProbeLongLongHashMapTest.this.memoryAllocator, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                long v;
                for (v = (long)s.hashAndMask(seed); s.hashAndMask(v) != 0 || v == 0L || v == 1L; ++v) {
                }
                int h = s.hashAndMask(v);
                elements = LongLists.mutable.with(new long[]{v});
                while (elements.size() < n) {
                    if (s.hashAndMask(++v) != h) continue;
                    elements.add(v);
                }
            }
            return elements.toImmutable();
        }

        @Test
        void addAll() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.collisions.toArray());
            Assertions.assertEquals((Object)this.collisions, (Object)LinearProbeLongLongHashMapTest.this.map.toSortedList());
        }

        @Test
        void addAllReversed() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.collisions.toReversed().toArray());
            Assertions.assertEquals((Object)this.collisions.toReversed(), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addAllRemoveLast() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.collisions.toArray());
            LinearProbeLongLongHashMapTest.this.map.remove(this.e);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b, this.c, this.d}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addAllRemoveFirst() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.collisions.toArray());
            LinearProbeLongLongHashMapTest.this.map.remove(this.a);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.b, this.c, this.d, this.e}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addAllRemoveMiddle() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.collisions.toArray());
            LinearProbeLongLongHashMapTest.this.map.remove(this.b);
            LinearProbeLongLongHashMapTest.this.map.remove(this.d);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c, this.e}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addAllRemoveMiddle2() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.collisions.toArray());
            LinearProbeLongLongHashMapTest.this.map.remove(this.a);
            LinearProbeLongLongHashMapTest.this.map.remove(this.c);
            LinearProbeLongLongHashMapTest.this.map.remove(this.e);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.b, this.d}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addReusesRemovedHead() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.a, this.b, this.c);
            LinearProbeLongLongHashMapTest.this.map.remove(this.a);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.b, this.c}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.this.map.put(this.d, 42L);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.d, this.b, this.c}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addReusesRemovedTail() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.a, this.b, this.c);
            LinearProbeLongLongHashMapTest.this.map.remove(this.c);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.this.map.put(this.d, 42L);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b, this.d}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addReusesRemovedMiddle() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.a, this.b, this.c);
            LinearProbeLongLongHashMapTest.this.map.remove(this.b);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.this.map.put(this.d, 42L);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.d, this.c}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void addReusesRemovedMiddle2() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.a, this.b, this.c, this.d, this.e);
            LinearProbeLongLongHashMapTest.this.map.remove(this.b);
            LinearProbeLongLongHashMapTest.this.map.remove(this.c);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.d, this.e}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.this.map.put(this.c, 1L);
            LinearProbeLongLongHashMapTest.this.map.put(this.b, 2L);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c, this.b, this.d, this.e}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }

        @Test
        void rehashingCompactsSparseSentinels() {
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.a, this.b, this.c, this.d, this.e);
            LinearProbeLongLongHashMapTest.this.map.remove(this.b);
            LinearProbeLongLongHashMapTest.this.map.remove(this.d);
            LinearProbeLongLongHashMapTest.this.map.remove(this.e);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.b, this.d, this.e);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.b, this.c, this.d, this.e}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.this.map.remove(this.b);
            LinearProbeLongLongHashMapTest.this.map.remove(this.d);
            LinearProbeLongLongHashMapTest.this.map.remove(this.e);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
            LinearProbeLongLongHashMapTest.this.map.rehashWithoutGrow();
            LinearProbeLongLongHashMapTest.fill((MutableLongLongMap)LinearProbeLongLongHashMapTest.this.map, this.e, this.d, this.b);
            Assertions.assertEquals((Object)LongArrayList.newListWith((long[])new long[]{this.a, this.c, this.e, this.d, this.b}), (Object)LinearProbeLongLongHashMapTest.this.map.toList());
        }
    }
}

