/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Iterator;
import java.util.function.IntUnaryOperator;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.EagerBuffer;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;

class EagerBufferTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final EagerBuffer<LongValue> eagerBuffer = EagerBuffer.createEagerBuffer((MemoryTracker)this.memoryTracker);

    EagerBufferTest() {
    }

    @AfterEach
    void tearDown() {
        this.eagerBuffer.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void emptySize() {
        long actual = this.meter.measureDeep(this.eagerBuffer) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actual, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void countInternalStructure() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        this.eagerBuffer.add((Measurable)Values.longValue((long)1L));
        this.eagerBuffer.add((Measurable)Values.longValue((long)2L));
        this.eagerBuffer.add((Measurable)Values.longValue((long)3L));
        long actualSize = this.meter.measureDeep(this.eagerBuffer) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actualSize, (long)(this.memoryTracker.estimatedHeapMemory() - externalAllocation));
        Iterator iterator = this.eagerBuffer.autoClosingIterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((long)1L, (long)((LongValue)iterator.next()).longValue());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((long)2L, (long)((LongValue)iterator.next()).longValue());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((long)3L, (long)((LongValue)iterator.next()).longValue());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }

    @Test
    void closeShouldReleaseEverything() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        this.eagerBuffer.add((Measurable)Values.longValue((long)1L));
        this.eagerBuffer.add((Measurable)Values.longValue((long)2L));
        this.eagerBuffer.add((Measurable)Values.longValue((long)3L));
        long actualSize = this.meter.measureDeep(this.eagerBuffer) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)(actualSize + externalAllocation), (long)this.memoryTracker.estimatedHeapMemory());
        this.eagerBuffer.close();
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }

    @Test
    void shouldHandleAddingMoreValuesThanCapacity() {
        EagerBuffer buffer1 = EagerBuffer.createEagerBuffer((MemoryTracker)this.memoryTracker, (int)16, (int)16, (IntUnaryOperator)EagerBuffer.KEEP_CONSTANT_CHUNK_SIZE);
        EagerBuffer buffer2 = EagerBuffer.createEagerBuffer((MemoryTracker)this.memoryTracker, (int)4, (int)16, (IntUnaryOperator)EagerBuffer.GROW_NEW_CHUNKS_BY_50_PCT);
        EagerBuffer buffer3 = EagerBuffer.createEagerBuffer((MemoryTracker)this.memoryTracker, (int)1, (int)16, (IntUnaryOperator)EagerBuffer.GROW_NEW_CHUNKS_BY_100_PCT);
        int nValues = 64;
        for (long i = 0L; i < (long)nValues; ++i) {
            buffer1.add((Measurable)Values.longValue((long)i));
            buffer2.add((Measurable)Values.longValue((long)i));
            buffer3.add((Measurable)Values.longValue((long)i));
        }
        Assertions.assertEquals((int)4, (int)buffer1.numberOfChunks());
        Assertions.assertEquals((int)6, (int)buffer2.numberOfChunks());
        Assertions.assertEquals((int)8, (int)buffer3.numberOfChunks());
        Iterator iterator1 = buffer1.autoClosingIterator();
        Iterator iterator2 = buffer2.autoClosingIterator();
        Iterator iterator3 = buffer3.autoClosingIterator();
        for (int i = 0; i < nValues; ++i) {
            Assertions.assertTrue((boolean)iterator1.hasNext());
            long value1 = ((LongValue)iterator1.next()).longValue();
            Assertions.assertEquals((long)i, (long)value1);
            Assertions.assertTrue((boolean)iterator2.hasNext());
            long value2 = ((LongValue)iterator2.next()).longValue();
            Assertions.assertEquals((long)i, (long)value2);
            Assertions.assertTrue((boolean)iterator3.hasNext());
            long value3 = ((LongValue)iterator3.next()).longValue();
            Assertions.assertEquals((long)i, (long)value3);
        }
        Assertions.assertFalse((boolean)iterator1.hasNext());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Assertions.assertFalse((boolean)iterator3.hasNext());
    }
}

