/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class FileUtilsTest {
    @Inject
    private TestDirectory testDirectory;
    private File path;

    FileUtilsTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.path = this.testDirectory.directory("path", new String[0]);
    }

    @Test
    void moveFileToDirectory() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = FileUtils.moveFileToDirectory((File)file, (File)targetDir);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newLocationOfFile.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)file.exists());
        File[] files = targetDir.listFiles();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)files);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newLocationOfFile, (Object)files[0]);
    }

    @Test
    void moveFile() throws Exception {
        File file = this.touchFile("source");
        File targetDir = this.directory("dir");
        File newLocationOfFile = new File(targetDir, "new-name");
        FileUtils.moveFile((File)file, (File)newLocationOfFile);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newLocationOfFile.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)file.exists());
        File[] files = targetDir.listFiles();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)files);
        org.junit.jupiter.api.Assertions.assertEquals((Object)newLocationOfFile, (Object)files[0]);
    }

    @Test
    void deletePathRecursively() throws IOException {
        File root = this.testDirectory.directory("a", new String[0]);
        File child = new File(root, "b");
        File file = new File(child, "c");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)child.mkdirs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.createNewFile());
        FileUtils.deletePathRecursively((Path)root.toPath());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)file.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child.exists());
    }

    @Test
    void deletePathRecursivelyWithFilter() throws IOException {
        File root = this.testDirectory.directory("a", new String[0]);
        File child = new File(root, "b");
        File file = new File(child, "c");
        File toKeepDir = new File(root, "d");
        File toKeepFile = new File(toKeepDir, "e");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)child.mkdirs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.createNewFile());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)toKeepDir.mkdirs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)toKeepFile.createNewFile());
        FileUtils.deletePathRecursively((Path)root.toPath(), path -> !path.equals(toKeepFile.toPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)file.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)child.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)toKeepFile.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)toKeepDir.exists());
    }

    @Test
    void deleteNestedPathRecursivelyWithFilter() throws IOException {
        File root = this.testDirectory.directory("a", new String[0]);
        File child = new File(root, "a");
        File file = new File(child, "aaFile");
        File toKeepDelete = new File(root, "b");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)child.mkdirs());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.createNewFile());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)toKeepDelete.mkdirs());
        FileUtils.deletePathRecursively((Path)root.toPath(), path -> !path.equals(file.toPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.exists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)child.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)toKeepDelete.exists());
    }

    @Test
    void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromShorter() {
        File file = new File("/a");
        File from = new File("/a/b");
        File to = new File("/a/c");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file));
    }

    @Test
    void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromSameLength() {
        File file = new File("/a/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file));
    }

    @Test
    void pathToFileAfterMoveMustThrowIfFileNotSubPathToFromLonger() {
        File file = new File("/a/c/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file));
    }

    @Test
    void pathToFileAfterMoveMustThrowIfFromDirIsCompletePathToFile() {
        File file = new File("/a/b/f");
        File from = new File("/a/b/f");
        File to = new File("/a/c");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfMovingToSibling() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/a/c/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfMovingToSiblingAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/c");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/a/c/d/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfMovingToSubDir() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/b/c");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/a/b/c/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfMovingToSubDirAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/b/c");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/a/b/c/d/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfMovingOutOfDir() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/c");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/c/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfMovingOutOfDirAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/c");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/c/d/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfNotMovingAtAll() {
        File file = new File("/a/b/f");
        File from = new File("/a/b");
        File to = new File("/a/b");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/a/b/f"));
    }

    @Test
    void pathToFileAfterMoveMustWorkIfNotMovingAtAllAndFileHasSubDir() {
        File file = new File("/a/b/d/f");
        File from = new File("/a/b");
        File to = new File("/a/b");
        Assertions.assertThat((String)FileUtils.pathToFileAfterMove((File)from, (File)to, (File)file).getPath()).isEqualTo(this.path("/a/b/d/f"));
    }

    @Test
    void allMacsHaveHighIO() {
        Assumptions.assumeTrue((boolean)SystemUtils.IS_OS_MAC);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtils.highIODevice((Path)Paths.get(".", new String[0])));
    }

    @Test
    void allWindowsHaveHighIO() {
        Assumptions.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtils.highIODevice((Path)Paths.get(".", new String[0])));
    }

    @Test
    void onLinuxDevShmHasHighIO() {
        Assumptions.assumeTrue((boolean)SystemUtils.IS_OS_LINUX);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtils.highIODevice((Path)Paths.get("/dev/shm", new String[0])));
    }

    @Test
    void mustCountDirectoryContents() throws Exception {
        File dir = this.directory("dir");
        File file = new File(dir, "file");
        File subdir = new File(dir, "subdir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.createNewFile());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)subdir.mkdirs());
        Assertions.assertThat((long)FileUtils.countFilesInDirectoryPath((Path)dir.toPath())).isEqualTo(2L);
    }

    @Test
    void nonExistingDirectoryCanBeDeleted() throws Exception {
        File dir = new File(this.path, "dir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtils.deleteFile((File)dir));
    }

    @Test
    void emptyDirectoryCanBeDeleted() throws Exception {
        File dir = this.directory("dir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtils.deleteFile((File)dir));
    }

    @Test
    void nonEmptyDirectoryCannotBeDeleted() throws Exception {
        File dir = this.directory("dir");
        File file = new File(dir, "file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.createNewFile());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileUtils.deleteFile((File)dir));
    }

    private File directory(String name) {
        File dir = new File(this.path, name);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dir.mkdirs());
        return dir;
    }

    private File touchFile(String name) throws IOException {
        File file = new File(this.path, name);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file.createNewFile());
        return file;
    }

    private String path(String path) {
        return new File(path).getPath();
    }
}

