/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;

class AutoCreatingHashMapTest {
    AutoCreatingHashMapTest() {
    }

    @Test
    void shouldCreateValuesIfMissing() {
        AutoCreatingHashMap map = new AutoCreatingHashMap(AutoCreatingHashMap.values(AtomicLong.class));
        String key = "should be created";
        ((AtomicLong)map.get(key)).incrementAndGet();
        Assertions.assertEquals((long)1L, (long)((AtomicLong)map.get(key)).get());
        Assertions.assertTrue((boolean)map.containsKey(key));
        Assertions.assertFalse((boolean)map.containsKey("any other key"));
    }

    @Test
    void shouldCreateValuesEvenForNestedMaps() {
        AutoCreatingHashMap map = new AutoCreatingHashMap(AutoCreatingHashMap.nested(AutoCreatingHashMap.nested(AutoCreatingHashMap.values(AtomicLong.class))));
        String keyLevelOne = "first";
        String keyLevelTwo = "second";
        String keyLevelThree = "third";
        ((AtomicLong)((Map)((Map)map.get(keyLevelOne)).get(keyLevelTwo)).get(keyLevelThree)).addAndGet(10L);
        Assertions.assertTrue((boolean)map.containsKey(keyLevelOne));
        Assertions.assertFalse((boolean)map.containsKey(keyLevelTwo));
        Map levelOne = (Map)map.get(keyLevelOne);
        Assertions.assertTrue((boolean)levelOne.containsKey(keyLevelTwo));
        Assertions.assertFalse((boolean)levelOne.containsKey(keyLevelThree));
        Map levelTwo = (Map)levelOne.get(keyLevelTwo);
        Assertions.assertTrue((boolean)levelTwo.containsKey(keyLevelThree));
        Assertions.assertFalse((boolean)levelTwo.containsKey(keyLevelOne));
        AtomicLong levelThree = (AtomicLong)levelTwo.get(keyLevelThree);
        Assertions.assertEquals((long)10L, (long)levelThree.get());
    }
}

