/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.AllEntriesTokenScanReader;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class DynamicIndexStoreViewTest {
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final RelationshipTypeScanStore relationshipTypeScanStore = (RelationshipTypeScanStore)Mockito.mock(RelationshipTypeScanStore.class);
    private final StubStorageCursors cursors = new StubStorageCursors();
    private final Visitor<EntityUpdates, Exception> propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final Visitor<EntityTokenUpdate, Exception> tokenUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
    private final IntPredicate propertyKeyIdFilter = (IntPredicate)Mockito.mock(IntPredicate.class);
    private final AllEntriesTokenScanReader nodeLabelRanges = (AllEntriesTokenScanReader)Mockito.mock(AllEntriesTokenScanReader.class);
    private final AllEntriesTokenScanReader relationshipTypeRanges = (AllEntriesTokenScanReader)Mockito.mock(AllEntriesTokenScanReader.class);
    private final Config config = Config.newBuilder().set(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, (Object)true).build();

    DynamicIndexStoreViewTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.labelScanStore.allEntityTokenRanges(PageCursorTracer.NULL)).thenReturn((Object)this.nodeLabelRanges);
        Mockito.when((Object)this.relationshipTypeScanStore.allEntityTokenRanges(PageCursorTracer.NULL)).thenReturn((Object)this.relationshipTypeRanges);
    }

    @Test
    void visitOnlyLabeledNodes() throws Exception {
        TokenScanReader labelScanReader = (TokenScanReader)Mockito.mock(TokenScanReader.class);
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)labelScanReader);
        Mockito.when((Object)this.nodeLabelRanges.maxCount()).thenReturn((Object)1L);
        long[] nodeIds = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        PrimitiveLongResourceIterator labeledNodesIterator = PrimitiveLongResourceCollections.iterator(null, (long[])nodeIds);
        Mockito.when((Object)labelScanReader.entitiesWithAnyOfTokens((int[])ArgumentMatchers.eq((Object)new int[]{2, 6}), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)labeledNodesIterator);
        for (long nodeId : nodeIds) {
            ((StubStorageCursors.NodeData)this.cursors.withNode(nodeId).propertyId(1L)).relationship(1L).labels(2L, 6L);
        }
        long id = nodeIds[nodeIds.length - 1] + 1L;
        for (long i = 0L; i < 10L; ++i) {
            this.cursors.withNode(id);
        }
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView();
        StoreScan storeScan = storeView.visitNodes(new int[]{2, 6}, this.propertyKeyIdFilter, this.propertyUpdateVisitor, this.tokenUpdateVisitor, false, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        ((Visitor)Mockito.verify(this.tokenUpdateVisitor, (VerificationMode)Mockito.times((int)nodeIds.length))).visit((Object)((EntityTokenUpdate)ArgumentMatchers.any()));
    }

    @Test
    void propertyUpdateVisitorVisitOnlyTargetRelationships() throws Throwable {
        TokenScanReader relationshipScanReader = (TokenScanReader)Mockito.mock(TokenScanReader.class);
        Mockito.when((Object)this.relationshipTypeScanStore.newReader()).thenReturn((Object)relationshipScanReader);
        Mockito.when((Object)this.relationshipTypeRanges.maxCount()).thenReturn((Object)1L);
        int targetType = 1;
        int notTargetType = 2;
        int[] targetTypeArray = new int[]{targetType};
        String targetPropertyKey = "key";
        String notTargetPropertyKey = "not-key";
        TextValue propertyValue = Values.stringValue((String)"value");
        MutableLongList relationshipsWithTargetType = LongLists.mutable.empty();
        long id = 0L;
        int wantedPropertyUpdates = 5;
        for (int i = 0; i < wantedPropertyUpdates; ++i) {
            this.cursors.withRelationship(id, 1L, targetType, 3L).properties(new Object[]{targetPropertyKey, propertyValue});
            relationshipsWithTargetType.add(id++);
            this.cursors.withRelationship(id, 1L, targetType, 3L).properties(new Object[]{notTargetPropertyKey, propertyValue});
            relationshipsWithTargetType.add(id++);
            this.cursors.withRelationship(id, 1L, notTargetType, 3L).properties(new Object[]{targetPropertyKey, propertyValue});
        }
        PrimitiveLongResourceIterator targetRelationshipsIterator = PrimitiveLongResourceCollections.iterator(null, (long[])relationshipsWithTargetType.toArray());
        Mockito.when((Object)relationshipScanReader.entitiesWithAnyOfTokens((int[])ArgumentMatchers.eq((Object)targetTypeArray), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)targetRelationshipsIterator);
        int targetPropertyKeyId = this.cursors.propertyKeyTokenHolder().getIdByName(targetPropertyKey);
        IntPredicate propertyKeyIdFilter = value -> value == targetPropertyKeyId;
        DynamicIndexStoreView storeView = this.dynamicIndexStoreView();
        StoreScan storeScan = storeView.visitRelationships(targetTypeArray, propertyKeyIdFilter, this.propertyUpdateVisitor, this.tokenUpdateVisitor, false, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run();
        ((Visitor)Mockito.verify(this.propertyUpdateVisitor, (VerificationMode)Mockito.times((int)wantedPropertyUpdates))).visit((Object)((EntityUpdates)ArgumentMatchers.any()));
        ((Visitor)Mockito.verify(this.tokenUpdateVisitor, (VerificationMode)Mockito.times((int)relationshipsWithTargetType.size()))).visit((Object)((EntityTokenUpdate)ArgumentMatchers.any()));
    }

    @Test
    void shouldNotDelegateToNeoStoreIndexStoreViewForRelationships() throws Throwable {
        NeoStoreIndexStoreView neoStoreIndexStoreView = (NeoStoreIndexStoreView)Mockito.mock(NeoStoreIndexStoreView.class);
        DynamicIndexStoreView dynamicIndexStoreView = this.dynamicIndexStoreView(neoStoreIndexStoreView);
        IntPredicate propertyKeyIdFilter = Predicates.ALWAYS_TRUE_INT;
        Visitor propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        Visitor relationshipTypeUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        PageCursorTracer cursorTracer = PageCursorTracer.NULL;
        int[] typeIds = new int[]{1};
        boolean forceStoreScan = false;
        Mockito.when((Object)this.relationshipTypeScanStore.isEmpty(cursorTracer)).thenReturn((Object)false);
        dynamicIndexStoreView.visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((NeoStoreIndexStoreView)Mockito.verify((Object)neoStoreIndexStoreView, (VerificationMode)Mockito.times((int)0))).visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void shouldDelegateToNeoStoreIndexStoreViewForRelationshipsIfForceStoreScan() throws Throwable {
        NeoStoreIndexStoreView neoStoreIndexStoreView = (NeoStoreIndexStoreView)Mockito.mock(NeoStoreIndexStoreView.class);
        DynamicIndexStoreView dynamicIndexStoreView = this.dynamicIndexStoreView(neoStoreIndexStoreView);
        IntPredicate propertyKeyIdFilter = Predicates.ALWAYS_TRUE_INT;
        Visitor propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        Visitor relationshipTypeUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        PageCursorTracer cursorTracer = PageCursorTracer.NULL;
        int[] typeIds = new int[]{1};
        Mockito.when((Object)this.relationshipTypeScanStore.isEmpty(cursorTracer)).thenReturn((Object)false);
        boolean forceStoreScan = true;
        dynamicIndexStoreView.visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((NeoStoreIndexStoreView)Mockito.verify((Object)neoStoreIndexStoreView, (VerificationMode)Mockito.times((int)1))).visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void shouldDelegateToNeoStoreIndexStoreViewForRelationshipsIfEmptyTypeArray() throws Throwable {
        NeoStoreIndexStoreView neoStoreIndexStoreView = (NeoStoreIndexStoreView)Mockito.mock(NeoStoreIndexStoreView.class);
        DynamicIndexStoreView dynamicIndexStoreView = this.dynamicIndexStoreView(neoStoreIndexStoreView);
        IntPredicate propertyKeyIdFilter = Predicates.ALWAYS_TRUE_INT;
        Visitor propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        Visitor relationshipTypeUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        PageCursorTracer cursorTracer = PageCursorTracer.NULL;
        boolean forceStoreScan = false;
        Mockito.when((Object)this.relationshipTypeScanStore.isEmpty(cursorTracer)).thenReturn((Object)false);
        int[] typeIds = ArrayUtils.EMPTY_INT_ARRAY;
        dynamicIndexStoreView.visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((NeoStoreIndexStoreView)Mockito.verify((Object)neoStoreIndexStoreView, (VerificationMode)Mockito.times((int)1))).visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void shouldDelegateToNeoStoreIndexStoreViewForRelationshipsIfFeatureToggleOff() throws Throwable {
        Config config = Config.newBuilder().set(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, (Object)false).build();
        NeoStoreIndexStoreView neoStoreIndexStoreView = (NeoStoreIndexStoreView)Mockito.mock(NeoStoreIndexStoreView.class);
        DynamicIndexStoreView dynamicIndexStoreView = this.dynamicIndexStoreView(neoStoreIndexStoreView, config);
        IntPredicate propertyKeyIdFilter = Predicates.ALWAYS_TRUE_INT;
        Visitor propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        Visitor relationshipTypeUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        PageCursorTracer cursorTracer = PageCursorTracer.NULL;
        int[] typeIds = new int[]{1};
        boolean forceStoreScan = false;
        Mockito.when((Object)this.relationshipTypeScanStore.isEmpty(cursorTracer)).thenReturn((Object)false);
        dynamicIndexStoreView.visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((NeoStoreIndexStoreView)Mockito.verify((Object)neoStoreIndexStoreView, (VerificationMode)Mockito.times((int)1))).visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void shouldDelegateToNeoStoreIndexStoreViewForRelationshipsIfEmptyRTSS() throws Throwable {
        NeoStoreIndexStoreView neoStoreIndexStoreView = (NeoStoreIndexStoreView)Mockito.mock(NeoStoreIndexStoreView.class);
        DynamicIndexStoreView dynamicIndexStoreView = this.dynamicIndexStoreView(neoStoreIndexStoreView);
        IntPredicate propertyKeyIdFilter = Predicates.ALWAYS_TRUE_INT;
        Visitor propertyUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        Visitor relationshipTypeUpdateVisitor = (Visitor)Mockito.mock(Visitor.class);
        PageCursorTracer cursorTracer = PageCursorTracer.NULL;
        int[] typeIds = new int[]{1};
        boolean forceStoreScan = false;
        Mockito.when((Object)this.relationshipTypeScanStore.isEmpty(cursorTracer)).thenReturn((Object)true);
        dynamicIndexStoreView.visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((NeoStoreIndexStoreView)Mockito.verify((Object)neoStoreIndexStoreView, (VerificationMode)Mockito.times((int)1))).visitRelationships(typeIds, propertyKeyIdFilter, propertyUpdateVisitor, relationshipTypeUpdateVisitor, forceStoreScan, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private DynamicIndexStoreView dynamicIndexStoreView() {
        LockService locks = LockService.NO_LOCK_SERVICE;
        Supplier<StorageReader> storageReaderSupplier = () -> this.cursors;
        return new DynamicIndexStoreView(new NeoStoreIndexStoreView(locks, storageReaderSupplier), this.labelScanStore, this.relationshipTypeScanStore, locks, storageReaderSupplier, (LogProvider)NullLogProvider.getInstance(), this.config);
    }

    private DynamicIndexStoreView dynamicIndexStoreView(NeoStoreIndexStoreView neoStoreIndexStoreView) {
        return this.dynamicIndexStoreView(neoStoreIndexStoreView, this.config);
    }

    private DynamicIndexStoreView dynamicIndexStoreView(NeoStoreIndexStoreView neoStoreIndexStoreView, Config config) {
        LockService locks = LockService.NO_LOCK_SERVICE;
        Supplier<StorageReader> storageReaderSupplier = () -> this.cursors;
        return new DynamicIndexStoreView(neoStoreIndexStoreView, this.labelScanStore, this.relationshipTypeScanStore, locks, storageReaderSupplier, (LogProvider)NullLogProvider.getInstance(), config);
    }
}

