/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.TransactionRepresentationFactory;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;

class Worker
implements Runnable {
    private final TransactionAppender transactionAppender;
    private final TransactionRepresentationFactory factory;
    private final BooleanSupplier condition;

    Worker(TransactionAppender transactionAppender, TransactionRepresentationFactory factory, BooleanSupplier condition) {
        this.transactionAppender = transactionAppender;
        this.factory = factory;
        this.condition = condition;
    }

    @Override
    public void run() {
        long latestTxId = 1L;
        while (this.condition.getAsBoolean()) {
            TransactionToApply transaction = this.factory.nextTransaction(latestTxId);
            try {
                latestTxId = this.transactionAppender.append(transaction, LogAppendEvent.NULL);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

