/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

class LogPositionTest {
    LogPositionTest() {
    }

    private static Stream<Arguments> logPositions() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new LogPosition(0L, 1L), new LogPosition(0L, 0L)}), Arguments.arguments((Object[])new Object[]{new LogPosition(0L, 11L), new LogPosition(0L, 7L)}), Arguments.arguments((Object[])new Object[]{new LogPosition(2L, 1L), new LogPosition(2L, 0L)}), Arguments.arguments((Object[])new Object[]{new LogPosition(2L, 17L), new LogPosition(2L, 15L)}), Arguments.arguments((Object[])new Object[]{new LogPosition(1L, 1L), new LogPosition(0L, 1L)}), Arguments.arguments((Object[])new Object[]{new LogPosition(5L, 1L), new LogPosition(3L, 10L)}), Arguments.arguments((Object[])new Object[]{new LogPosition(Integer.MAX_VALUE, 0x80000000L), new LogPosition(Integer.MAX_VALUE, Integer.MAX_VALUE)}), Arguments.arguments((Object[])new Object[]{new LogPosition(Long.MAX_VALUE, Long.MAX_VALUE), new LogPosition(0x80000000L, Long.MAX_VALUE)}), Arguments.arguments((Object[])new Object[]{new LogPosition(Long.MAX_VALUE, Long.MAX_VALUE), new LogPosition(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL)}));
    }

    @ParameterizedTest
    @MethodSource(value={"logPositions"})
    void logPositionComparison(LogPosition logPositionA, LogPosition logPositionB) {
        Assertions.assertEquals((int)1, (int)logPositionA.compareTo(logPositionB));
        Assertions.assertEquals((int)-1, (int)logPositionB.compareTo(logPositionA));
        Assertions.assertEquals((int)0, (int)logPositionA.compareTo(logPositionA));
        Assertions.assertEquals((int)0, (int)logPositionB.compareTo(logPositionB));
    }
}

