/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;

class TransactionMetadataCacheTest {
    TransactionMetadataCacheTest() {
    }

    @Test
    void shouldReturnNullWhenMissingATxInTheCache() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assertions.assertNull((Object)metadata);
    }

    @Test
    void shouldReturnTheTxValueTIfInTheCached() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LogPosition position = new LogPosition(3L, 4L);
        int txId = 42;
        int checksum = 2;
        long timestamp = System.currentTimeMillis();
        cache.cacheTransactionMetadata(42L, position, 2, timestamp);
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assertions.assertEquals((Object)new TransactionMetadataCache.TransactionMetadata(position, 2, timestamp), (Object)metadata);
    }

    @Test
    void shouldThrowWhenCachingATxWithNegativeOffsetPosition() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LogPosition position = new LogPosition(3L, -1L);
        int txId = 42;
        int checksum = 2;
        long timestamp = System.currentTimeMillis();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> cache.cacheTransactionMetadata(42L, position, 2, timestamp));
        Assertions.assertEquals((Object)("StartEntry.position is " + position), (Object)e.getMessage());
    }

    @Test
    void shouldClearTheCache() {
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LogPosition position = new LogPosition(3L, 4L);
        int txId = 42;
        int checksum = 2;
        long timestamp = System.currentTimeMillis();
        cache.cacheTransactionMetadata(42L, position, 2, timestamp);
        cache.clear();
        TransactionMetadataCache.TransactionMetadata metadata = cache.getTransactionMetadata(42L);
        Assertions.assertNull((Object)metadata);
    }
}

