/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.LogFileChannelNativeAccessor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ReadAheadLogChannelTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory directory;
    private final LogFileChannelNativeAccessor nativeChannelAccessor = (LogFileChannelNativeAccessor)Mockito.mock(LogFileChannelNativeAccessor.class);

    ReadAheadLogChannelTest() {
    }

    @Test
    void shouldReadFromSingleChannel() throws Exception {
        File file = this.file(0);
        int byteValue = 5;
        int shortValue = 56;
        int intValue = 32145;
        long longValue = 5689456895869L;
        float floatValue = 12.12345f;
        double doubleValue = 3548.45748;
        byte[] byteArrayValue = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.writeSomeData(file, (Visitor<ByteBuffer, IOException>)((Visitor)element -> {
            element.put((byte)5);
            element.putShort((short)56);
            element.putInt(32145);
            element.putLong(5689456895869L);
            element.putFloat(12.12345f);
            element.putDouble(3548.45748);
            element.put(byteArrayValue);
            return true;
        }));
        StoreChannel storeChannel = this.fileSystem.read(file);
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, -1L, -1, file, (ChannelNativeAccessor)this.nativeChannelAccessor);
        try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Assertions.assertEquals((byte)5, (byte)channel.get());
            Assertions.assertEquals((short)56, (short)channel.getShort());
            Assertions.assertEquals((int)32145, (int)channel.getInt());
            Assertions.assertEquals((long)5689456895869L, (long)channel.getLong());
            Assertions.assertEquals((float)12.12345f, (float)channel.getFloat(), (float)0.1f);
            Assertions.assertEquals((double)3548.45748, (double)channel.getDouble(), (double)0.1);
            byte[] bytes = new byte[byteArrayValue.length];
            channel.get(bytes, byteArrayValue.length);
            Assertions.assertArrayEquals((byte[])byteArrayValue, (byte[])bytes);
        }
    }

    @Test
    void shouldReadFromMultipleChannels() throws Exception {
        this.writeSomeData(this.file(0), (Visitor<ByteBuffer, IOException>)((Visitor)element -> {
            for (int i = 0; i < 10; ++i) {
                element.putLong(i);
            }
            return true;
        }));
        this.writeSomeData(this.file(1), (Visitor<ByteBuffer, IOException>)((Visitor)element -> {
            for (int i = 10; i < 20; ++i) {
                element.putLong(i);
            }
            return true;
        }));
        StoreChannel storeChannel = this.fileSystem.read(this.file(0));
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(storeChannel, -1L, -1, this.file(0), (ChannelNativeAccessor)this.nativeChannelAccessor);
        try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, new LogVersionBridge(){
            private boolean returned;

            public LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
                if (!this.returned) {
                    this.returned = true;
                    channel.close();
                    return new PhysicalLogVersionedStoreChannel(ReadAheadLogChannelTest.this.fileSystem.read(ReadAheadLogChannelTest.this.file(1)), -1L, -1, ReadAheadLogChannelTest.this.file(1), (ChannelNativeAccessor)ReadAheadLogChannelTest.this.nativeChannelAccessor);
                }
                return channel;
            }
        }, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            for (long i = 0L; i < 20L; ++i) {
                Assertions.assertEquals((long)i, (long)channel.getLong());
            }
        }
    }

    private void writeSomeData(File file, Visitor<ByteBuffer, IOException> visitor) throws IOException {
        try (StoreChannel channel = this.fileSystem.write(file);){
            ByteBuffer buffer = ByteBuffers.allocate((int)1, (ByteUnit)ByteUnit.KibiByte, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            visitor.visit((Object)buffer);
            buffer.flip();
            channel.writeAll(buffer);
        }
    }

    private File file(int index) {
        return new File(this.directory.homeDir(), "" + index);
    }
}

