/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@TestDirectoryExtension
class ConfigurableStandalonePageCacheFactoryTest {
    @Inject
    private TestDirectory testDirectory;

    ConfigurableStandalonePageCacheFactoryTest() {
    }

    @Test
    void mustAutomaticallyStartEvictionThread() throws Exception {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();){
            File file = new File(this.testDirectory.homeDir(), "a").getCanonicalFile();
            fs.write(file).close();
            try (PageCache cache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler, (PageCacheTracer)PageCacheTracer.NULL);
                 PagedFile pf = cache.map(file, 4096);
                 PageCursor cursor = pf.io(0L, 2, PageCursorTracer.NULL);){
                for (int i = 0; i < 10000; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(42);
                }
            }
        }
    }
}

