/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DetachingRelationshipDeleterTest;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.opentest4j.AssertionFailedError;

class OperationsTest {
    private KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private Operations operations;
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final Write write = (Write)Mockito.mock(Write.class);
    private InOrder order;
    private FullAccessNodeCursor nodeCursor;
    private FullAccessPropertyCursor propertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;
    private TransactionState txState;
    private AllStoreHolder allStoreHolder;
    private final LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)123, (int[])new int[]{456});
    private StorageReader storageReader;
    private StorageSchemaReader storageReaderSnapshot;
    private ConstraintIndexCreator constraintIndexCreator;
    private IndexingService indexingService;
    private TokenHolders tokenHolders;
    private CommandCreationContext creationContext;

    OperationsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        TxState realTxState = new TxState();
        this.txState = (TransactionState)Mockito.spy((Object)realTxState);
        Mockito.when((Object)this.transaction.getReasonIfTerminated()).thenReturn(Optional.empty());
        Mockito.when((Object)this.transaction.statementLocks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
        Mockito.when((Object)this.transaction.dataWrite()).thenReturn((Object)this.write);
        Mockito.when((Object)this.transaction.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.lockTracer()).thenReturn((Object)LockTracer.NONE);
        Mockito.when((Object)this.transaction.txState()).thenReturn((Object)this.txState);
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        DefaultPooledCursors cursors = (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class);
        this.nodeCursor = (FullAccessNodeCursor)Mockito.mock(FullAccessNodeCursor.class);
        this.propertyCursor = (FullAccessPropertyCursor)Mockito.mock(FullAccessPropertyCursor.class);
        this.relationshipCursor = (DefaultRelationshipScanCursor)Mockito.mock(DefaultRelationshipScanCursor.class);
        Mockito.when((Object)cursors.allocateFullAccessNodeCursor(PageCursorTracer.NULL)).thenReturn((Object)this.nodeCursor);
        Mockito.when((Object)cursors.allocateFullAccessPropertyCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).thenReturn((Object)this.propertyCursor);
        Mockito.when((Object)cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL)).thenReturn((Object)this.relationshipCursor);
        StorageEngine engine = (StorageEngine)Mockito.mock(StorageEngine.class);
        this.storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        this.storageReaderSnapshot = (StorageSchemaReader)Mockito.mock(StorageSchemaReader.class);
        Mockito.when((Object)this.storageReader.nodeExists(ArgumentMatchers.anyLong(), (PageCursorTracer)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.constraintsGetForLabel(ArgumentMatchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.constraintsGetAll()).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.schemaSnapshot()).thenReturn((Object)this.storageReaderSnapshot);
        Mockito.when((Object)engine.newReader()).thenReturn((Object)this.storageReader);
        this.indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Dependencies dependencies = new Dependencies();
        GraphDatabaseFacade facade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        dependencies.satisfyDependency((Object)facade);
        this.allStoreHolder = new AllStoreHolder(this.storageReader, this.transaction, cursors, (GlobalProcedures)Mockito.mock(GlobalProcedures.class), (SchemaState)Mockito.mock(SchemaState.class), this.indexingService, (LabelScanStore)Mockito.mock(LabelScanStore.class), (RelationshipTypeScanStore)Mockito.mock(RelationshipTypeScanStore.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), PageCursorTracer.NULL, dependencies, Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.constraintIndexCreator = (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class);
        this.tokenHolders = DatabaseRule.mockedTokenHolders();
        this.creationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        IndexingProvidersService indexingProvidersService = (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class);
        Mockito.when((Object)indexingProvidersService.indexProviderByName("native-btree-1.0")).thenReturn((Object)GenericNativeIndexProvider.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.getDefaultProvider()).thenReturn((Object)GenericNativeIndexProvider.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.indexProviderByName("fulltext-1.0")).thenReturn((Object)FulltextIndexProviderFactory.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.getFulltextProvider()).thenReturn((Object)FulltextIndexProviderFactory.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.indexProviderByName("provider-1.0")).thenReturn((Object)new IndexProviderDescriptor("provider", "1.0"));
        Mockito.when((Object)indexingProvidersService.completeConfiguration((IndexDescriptor)ArgumentMatchers.any())).thenAnswer(inv -> inv.getArgument(0));
        this.operations = new Operations(this.allStoreHolder, this.storageReader, (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), this.creationContext, this.transaction, new KernelToken(this.storageReader, this.creationContext, this.transaction, this.tokenHolders), cursors, this.constraintIndexCreator, (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), indexingProvidersService, Config.defaults(), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.operations.initialize();
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks, this.txState, this.storageReader, this.storageReaderSnapshot});
    }

    @AfterEach
    void tearDown() {
        this.operations.release();
    }

    @Test
    void shouldAcquireEntityWriteLockCreatingRelationship() throws Exception {
        long rId = this.operations.relationshipCreate(1L, 2, 3L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoCreate(rId, 2, 1L, 3L);
    }

    @Test
    void shouldAcquireNodeLocksWhenCreatingRelationshipInOrderOfAscendingId() throws Exception {
        long lowId = 3L;
        long highId = 5L;
        int relationshipLabel = 0;
        this.operations.relationshipCreate(lowId, relationshipLabel, highId);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        this.operations.relationshipCreate(highId, relationshipLabel, lowId);
        InOrder lowLockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lowLockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lowLockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{highId});
        lowLockingOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireNodeLocksWhenDeletingRelationshipInOrderOfAscendingId() {
        long relationshipId = 10L;
        long lowId = 3L;
        long highId = 5L;
        int relationshipLabel = 0;
        this.setStoreRelationship(10L, 3L, 5L, relationshipLabel);
        this.operations.relationshipDelete(10L);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        this.setStoreRelationship(10L, 5L, 3L, relationshipLabel);
        this.operations.relationshipDelete(10L);
        InOrder highLowIdOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)highLowIdOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)highLowIdOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)highLowIdOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        highLowIdOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeAddingLabelToNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        this.operations.nodeAddLabel(123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddLabel(456L, 123L);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeAddingLabelToJustCreatedNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.nodeDoCreate(123L);
        this.operations.nodeAddLabel(123L, 456);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeAddingLabelToNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        int labelId = 456;
        this.operations.nodeAddLabel(123L, labelId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddLabel((long)labelId, 123L);
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeSettingPropertyOnNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeSettingPropertyOnNode() throws Exception {
        int relatedLabelId = 50;
        int unrelatedLabelId = 51;
        int propertyKeyId = 8;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet tokenSet = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)tokenSet.all()).thenReturn((Object)new long[]{relatedLabelId});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)tokenSet);
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{relatedLabelId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{unrelatedLabelId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeSettingPropertyOnRelationship() throws Exception {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.relationshipSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoReplaceProperty(123L, propertyKeyId, Values.NO_VALUE, value);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.nodeDoCreate(123L);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedRelationship() throws Exception {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.relationshipDoCreate(123L, 42, 43L, 45L);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.operations.relationshipSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).relationshipDoReplaceProperty(123L, propertyKeyId, Values.NO_VALUE, value);
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeDeletingNode() {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        this.operations.nodeDelete(123L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(123L);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeDeletingJustCreatedNode() {
        this.txState.nodeDoCreate(123L);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.operations.nodeDelete(123L);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).nodeDoDelete(123L);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabelAndProperty() {
        this.allStoreHolder.constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
    }

    @Test
    void shouldNotAcquireSchemaReadLockBeforeGettingIndexesByLabelAndProperty() {
        this.allStoreHolder.index((SchemaDescriptor)this.schema);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageReader)Mockito.verify((Object)this.storageReader)).indexGetForSchema((SchemaDescriptor)this.schema);
    }

    @Test
    void shouldNotAcquireSchemaReadLockWhenGettingIndexesByLabelAndPropertyFromSnapshot() {
        this.allStoreHolder.snapshot().index((SchemaDescriptor)this.schema);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).indexGetForSchema((SchemaDescriptor)this.schema);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabel() {
        this.allStoreHolder.constraintsGetForLabel(42);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{42L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForLabel(42);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeGettingConstraintsByRelationshipType() {
        this.allStoreHolder.constraintsGetForRelationshipType(42);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{42L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForRelationshipType(42);
    }

    @Test
    void shouldNotAcquireSchemaReadLockBeforeGettingConstraintsByLabel() {
        this.allStoreHolder.snapshot().constraintsGetForLabel(42);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).constraintsGetForLabel(42);
    }

    @Test
    void shouldNotAcquireSchemaReadLockBeforeGettingConstraintsByRelationshipType() {
        this.allStoreHolder.snapshot().constraintsGetForRelationshipType(42);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).constraintsGetForRelationshipType(42);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeCheckingExistenceConstraints() {
        this.allStoreHolder.constraintExists((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema));
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{123L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintExists((ConstraintDescriptor)ArgumentMatchers.any());
    }

    @Test
    void shouldAcquireSchemaReadLockLazilyBeforeGettingAllConstraints() {
        int labelId = 1;
        int relTypeId = 2;
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{2, 3, 3});
        RelExistenceConstraintDescriptor existenceConstraint = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{3, 4, 5});
        Mockito.when((Object)this.storageReader.constraintsGetAll()).thenReturn((Object)Iterators.iterator((Object[])new ConstraintDescriptor[]{uniquenessConstraint, existenceConstraint}));
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)uniquenessConstraint)).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)existenceConstraint)).thenReturn((Object)true);
        Iterator result = this.allStoreHolder.constraintsGetAll();
        Assertions.assertThat((long)Iterators.count((Iterator)result)).isEqualTo(2L);
        Assertions.assertThat((List)Iterators.asList((Iterator)result)).isEmpty();
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetAll();
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.atLeastOnce())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.atLeastOnce())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
    }

    @Test
    void shouldNotAcquireSchemaReadLockLazilyBeforeGettingAllConstraintsFromSnapshot() {
        int labelId = 1;
        int relTypeId = 2;
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{2, 3, 3});
        RelExistenceConstraintDescriptor existenceConstraint = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{3, 4, 5});
        Mockito.when((Object)this.storageReaderSnapshot.constraintsGetAll()).thenReturn((Object)Iterators.iterator((Object[])new ConstraintDescriptor[]{uniquenessConstraint, existenceConstraint}));
        Iterator result = this.allStoreHolder.snapshot().constraintsGetAll();
        Assertions.assertThat((long)Iterators.count((Iterator)result)).isEqualTo(2L);
        Assertions.assertThat((List)Iterators.asList((Iterator)result)).isEmpty();
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).constraintsGetAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeRemovingIndexRule() throws Exception {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0})).withName("index").materialise(0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)index);
        Mockito.when((Object)this.indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        this.operations.indexDrop(index);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeRemovingIndexRuleBySchema() throws Exception {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0})).withName("index").materialise(0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)index);
        Mockito.when((Object)this.indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.indexGetForSchema(index.schema())).thenReturn((Object)Iterators.iterator((Object)index));
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        this.operations.indexDrop(index.schema());
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldDropAllGeneralIndexesMatchingSchema() throws Exception {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
        FulltextSchemaDescriptor ftsSchema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{0}, (int[])new int[]{0});
        IndexDescriptor indexA = IndexPrototype.forSchema((SchemaDescriptor)schema).withName("a").materialise(0L);
        IndexDescriptor indexB = IndexPrototype.forSchema((SchemaDescriptor)ftsSchema).withName("b").withIndexType(IndexType.FULLTEXT).materialise(1L);
        IndexDescriptor indexC = IndexPrototype.forSchema((SchemaDescriptor)schema).withName("c").materialise(2L);
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)schema)).thenReturn((Object)Iterators.iterator((Object[])new IndexDescriptor[]{indexA, indexB, indexC}));
        Mockito.when((Object)this.storageReader.indexExists((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).thenReturn((Object)true);
        this.operations.indexDrop((SchemaDescriptor)schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(indexA);
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(indexC);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoDrop(indexB);
    }

    @Test
    void shouldAcquireSchemaNameWriteLockBeforeRemovingIndexByName() throws Exception {
        String indexName = "My fancy index";
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0})).withName(indexName).materialise(0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)index);
        Mockito.when((Object)this.indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.indexGetForName(indexName)).thenReturn((Object)index);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        this.operations.indexDrop(indexName);
        long indexNameLock = ResourceIds.schemaNameResourceId((String)indexName);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA_NAME, new long[]{indexNameLock});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeCreatingUniquenessConstraint() throws Exception {
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype))).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema(this.schema.schema())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema(this.schema.schema())).thenReturn(Collections.emptyIterator());
        this.operations.uniquePropertyConstraintCreate(prototype);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoAdd((IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema), constraintIndex);
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfConstraintCreationFails() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int labelId = this.schema.getLabelId();
        int propertyId = this.schema.getPropertyId();
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(labelId)).thenReturn((Object)new NamedToken("Label", labelId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", labelId));
        try {
            this.operations.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{labelId});
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfNodeKeyConstraintCreationFails() throws Exception {
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)this.schema);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int labelId = this.schema.getLabelId();
        int propertyId = this.schema.getPropertyId();
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(labelId)).thenReturn((Object)new NamedToken("Label", labelId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", labelId));
        try {
            this.operations.nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{labelId});
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfNodePropertyExistenceConstraintCreationFails() throws Exception {
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((LabelSchemaDescriptor)this.schema);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int labelId = this.schema.getLabelId();
        int propertyId = this.schema.getPropertyId();
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(labelId)).thenReturn((Object)new NamedToken("Label", labelId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", labelId));
        try {
            this.operations.nodePropertyExistenceConstraintCreate(this.schema, "constraint name");
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{labelId});
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfRelationshipPropertyExistenceConstraintCreationFails() throws Exception {
        RelationTypeSchemaDescriptor descriptor = SchemaDescriptor.forRelType((int)11, (int[])new int[]{13});
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((RelationTypeSchemaDescriptor)descriptor);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int relTypeId = descriptor.getRelTypeId();
        int propertyId = descriptor.getPropertyId();
        Mockito.when((Object)this.tokenHolders.relationshipTypeTokens().getTokenById(relTypeId)).thenReturn((Object)new NamedToken("Label", relTypeId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", relTypeId));
        try {
            this.operations.relationshipPropertyExistenceConstraintCreate(descriptor, "constraint name");
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)descriptor);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeDroppingConstraint() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint");
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint").materialise(13L);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.indexGetForName("constraint")).thenReturn((Object)index);
        this.operations.constraintDrop((ConstraintDescriptor)constraint);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoDrop((ConstraintDescriptor)constraint);
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaNameWriteLockBeforeDroppingConstraintByName() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint");
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint").materialise(13L);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.indexGetForName("constraint")).thenReturn((Object)index);
        Mockito.when((Object)this.storageReader.constraintGetForName("constraint")).thenReturn((Object)constraint);
        this.operations.constraintDrop("constraint");
        long nameLock = ResourceIds.schemaNameResourceId((String)"constraint");
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA_NAME, new long[]{nameLock});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoDrop((ConstraintDescriptor)constraint);
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void detachDeleteNodeWithoutRelationshipsExclusivelyLockNode() {
        long nodeId = 1L;
        DetachingRelationshipDeleterTest.returnRelationships(this.transaction, new TestRelationshipChain(nodeId));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDetachDelete(nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(nodeId);
    }

    @Test
    void detachDeleteNodeExclusivelyLockNodes() {
        long nodeId = 1L;
        DetachingRelationshipDeleterTest.returnRelationships(this.transaction, new TestRelationshipChain(nodeId).outgoing(1L, 2L, 42));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        this.operations.nodeDetachDelete(nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId, 2L});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{2L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(nodeId);
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenDeletingNode() {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 2L;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDelete(nodeId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenDetachDeletingNode() {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 2L;
        DetachingRelationshipDeleterTest.returnRelationships(this.transaction, new TestRelationshipChain(nodeId));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDetachDelete(nodeId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenRemovingNodeLabel() throws EntityNotFoundException {
        long nodeId = 1L;
        int labelId = 1;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.hasLabel(labelId)).thenReturn((Object)true);
        this.operations.nodeRemoveLabel(nodeId, labelId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        order.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenRemovingNodeProperty() throws EntityNotFoundException {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 1L;
        int propertyKeyId = 5;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.of((Object)"abc"));
        this.operations.nodeRemoveProperty(nodeId, propertyKeyId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    @Test
    void mustAssignNameToIndexesThatDoNotHaveUserSuppliedName() throws Exception {
        Mockito.when((Object)this.creationContext.reserveSchema()).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L});
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(1)).thenReturn((Object)new NamedToken("LabelA", 1));
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(2)).thenReturn((Object)new NamedToken("LabelB", 1));
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(3)).thenReturn((Object)new NamedToken("LabelC", 1));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(1)).thenReturn((Object)new NamedToken("PropA", 1));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(2)).thenReturn((Object)new NamedToken("PropB", 2));
        this.storageReaderWithoutConstraints();
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn(Collections.emptyIterator());
        this.operations.indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1}), null);
        this.operations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{2, 3}, (int[])new int[]{1, 2})).withIndexType(IndexType.FULLTEXT));
        this.operations.indexCreate((SchemaDescriptor)SchemaDescriptor.forLabel((int)3, (int[])new int[]{1}), "provider-1.0", null);
        Object[] indexDescriptors = (IndexDescriptor[])this.txState.indexChanges().getAdded().stream().sorted(Comparator.comparing(d -> d.schema().getEntityTokenIds()[0])).toArray(IndexDescriptor[]::new);
        ((AbstractIntegerAssert)Assertions.assertThat((int)indexDescriptors.length).as(Arrays.toString(indexDescriptors), new Object[0])).isEqualTo(3);
        ((AbstractLongAssert)Assertions.assertThat((long)indexDescriptors[0].getId()).as(indexDescriptors[0].toString(), new Object[0])).isEqualTo(1L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexDescriptors[1].getId()).as(indexDescriptors[1].toString(), new Object[0])).isEqualTo(2L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexDescriptors[2].getId()).as(indexDescriptors[2].toString(), new Object[0])).isEqualTo(3L);
        ((AbstractStringAssert)Assertions.assertThat((String)indexDescriptors[0].getName()).as(indexDescriptors[0].toString(), new Object[0])).isEqualTo("index_5c81a58e");
        ((AbstractStringAssert)Assertions.assertThat((String)indexDescriptors[1].getName()).as(indexDescriptors[1].toString(), new Object[0])).isEqualTo("index_2813986a");
        ((AbstractStringAssert)Assertions.assertThat((String)indexDescriptors[2].getName()).as(indexDescriptors[2].toString(), new Object[0])).isEqualTo("index_edb2dfd3");
    }

    @Test
    void uniqueIndexesMustBeNamedAfterTheirConstraints() throws KernelException {
        Mockito.when((Object)this.creationContext.reserveSchema()).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L});
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        String constraintName = "my_constraint";
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.any())).thenAnswer(i -> {
            IndexPrototype prototype = (IndexPrototype)i.getArgument(2);
            Optional name = prototype.getName();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)name.isPresent());
            Assertions.assertThat((String)((String)name.get())).isEqualTo(constraintName);
            return prototype.materialise(2L);
        });
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName(constraintName);
        IndexBackedConstraintDescriptor constraint = this.operations.uniquePropertyConstraintCreate(prototype).asIndexBackedConstraint();
        Assertions.assertThat((long)constraint.ownedIndexId()).isEqualTo(2L);
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingNodeIdInBareCreateMethod() {
        SecurityContext sctx = (SecurityContext)Mockito.mock(SecurityContext.class);
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)sctx);
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        Mockito.when((Object)sctx.mode()).thenReturn((Object)AccessMode.Static.FULL);
        Operations operations = new Operations((AllStoreHolder)Mockito.mock(AllStoreHolder.class), (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, ktx, (KernelToken)Mockito.mock(KernelToken.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class), (Config)Mockito.mock(Config.class), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        operations.nodeCreate();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveNode();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingNodeIdInCreateWithLabelsMethod() throws ConstraintValidationException {
        SecurityContext sctx = (SecurityContext)Mockito.mock(SecurityContext.class);
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        Mockito.when((Object)ktx.statementLocks()).thenReturn((Object)statementLocks);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)sctx);
        Mockito.when((Object)statementLocks.optimistic()).thenReturn((Object)((Locks.Client)Mockito.mock(Locks.Client.class)));
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        DefaultPooledCursors cursors = (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class);
        Mockito.when((Object)cursors.allocateFullAccessNodeCursor(PageCursorTracer.NULL)).thenReturn((Object)((FullAccessNodeCursor)Mockito.mock(FullAccessNodeCursor.class)));
        Mockito.when((Object)cursors.allocateFullAccessPropertyCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).thenReturn((Object)((FullAccessPropertyCursor)Mockito.mock(FullAccessPropertyCursor.class)));
        Mockito.when((Object)sctx.mode()).thenReturn((Object)AccessMode.Static.FULL);
        Operations operations = new Operations((AllStoreHolder)Mockito.mock(AllStoreHolder.class), (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, ktx, (KernelToken)Mockito.mock(KernelToken.class), cursors, (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class), (Config)Mockito.mock(Config.class), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        operations.initialize();
        operations.nodeCreateWithLabels(new int[]{1});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveNode();
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingRelationshipId() throws EntityNotFoundException {
        SecurityContext sctx = (SecurityContext)Mockito.mock(SecurityContext.class);
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        Mockito.when((Object)ktx.statementLocks()).thenReturn((Object)statementLocks);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)sctx);
        Mockito.when((Object)statementLocks.optimistic()).thenReturn((Object)((Locks.Client)Mockito.mock(Locks.Client.class)));
        Mockito.when((Object)statementLocks.pessimistic()).thenReturn((Object)((Locks.Client)Mockito.mock(Locks.Client.class)));
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        AllStoreHolder allStoreHolder = (AllStoreHolder)Mockito.mock(AllStoreHolder.class);
        Mockito.when((Object)allStoreHolder.nodeExists(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)sctx.mode()).thenReturn((Object)AccessMode.Static.FULL);
        Operations operations = new Operations(allStoreHolder, (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, ktx, (KernelToken)Mockito.mock(KernelToken.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class), (Config)Mockito.mock(Config.class), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        operations.relationshipCreate(0L, 1, 2L);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveRelationship();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingSchemaId() throws KernelException {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class);
        Mockito.when((Object)ktx.statementLocks()).thenReturn((Object)statementLocks);
        Mockito.when((Object)statementLocks.optimistic()).thenReturn((Object)((Locks.Client)Mockito.mock(Locks.Client.class)));
        Mockito.when((Object)statementLocks.pessimistic()).thenReturn((Object)((Locks.Client)Mockito.mock(Locks.Client.class)));
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        IndexingProvidersService indexingProvidersService = (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class);
        Mockito.when((Object)indexingProvidersService.getDefaultProvider()).thenReturn((Object)((IndexProviderDescriptor)Mockito.mock(IndexProviderDescriptor.class)));
        AllStoreHolder allStoreHolder = (AllStoreHolder)Mockito.mock(AllStoreHolder.class);
        Mockito.when((Object)allStoreHolder.index((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        Mockito.when((Object)allStoreHolder.indexGetForName((String)ArgumentMatchers.any())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        Mockito.when((Object)allStoreHolder.constraintsGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        Operations operations = new Operations(allStoreHolder, (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, ktx, (KernelToken)Mockito.mock(KernelToken.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), indexingProvidersService, Config.defaults(), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        operations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("name"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveSchema();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnIndexTypeFullText() throws Exception {
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).withIndexType(IndexType.FULLTEXT);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype))).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)new InMemoryTokens())).contains(new CharSequence[]{"FULLTEXT"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnFulltextSchemas() throws Exception {
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("Label", 123));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("prop", 456));
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])this.schema.getEntityTokenIds(), (int[])this.schema.getPropertyIds());
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype))).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).contains(new CharSequence[]{"full-text schema"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnRelationshipSchemas() throws Exception {
        Mockito.when((Object)this.tokenHolders.relationshipTypeTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("RelType", 123));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("prop", 456));
        RelationTypeSchemaDescriptor schema = SchemaDescriptor.forRelType((int)this.schema.getEntityTokenIds()[0], (int[])this.schema.getPropertyIds());
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype))).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).contains(new CharSequence[]{"relationship type schema"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnNonUniqueIndexPrototypes() throws Exception {
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("Label", 123));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("prop", 456));
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype))).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        ((AbstractStringAssert)Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).containsIgnoringCase((CharSequence)"index prototype")).containsIgnoringCase((CharSequence)"not unique");
    }

    @Test
    void nodeAddLabelShouldFailReadOnly() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.READ, false);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"Set label for label 'Label' is not allowed"});
    }

    @Test
    void nodeAddLabelShouldFailAccess() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.ACCESS, false);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"Set label for label 'Label' is not allowed"});
    }

    @Test
    void nodeAddLabelShouldSucceedWriteOnly() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.WRITE_ONLY, true);
    }

    @Test
    void nodeAddLabelShouldSucceedWrite() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.WRITE, true);
    }

    @Test
    void nodeAddLabelShouldSucceedWriteFull() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.FULL, true);
    }

    @Test
    void nodeRemoveLabelShouldFailReadOnly() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.READ, false);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"Remove label for label 'Label' is not allowed"});
    }

    @Test
    void nodeRemoveLabelShouldFailAccess() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.ACCESS, false);
        Assertions.assertThat((String)message).contains(new CharSequence[]{"Remove label for label 'Label' is not allowed"});
    }

    @Test
    void nodeRemoveLabelShouldSucceedWriteOnly() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.WRITE_ONLY, true);
    }

    @Test
    void nodeRemoveLabelShouldSucceedWrite() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.WRITE, true);
    }

    @Test
    void nodeRemoveLabelShouldSucceedWriteFull() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.FULL, true);
    }

    private String runForSecurityLevel(Executable executable, AccessMode mode, boolean shoudldBeAuthorized) throws Exception {
        SecurityContext sctx = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)sctx);
        Mockito.when((Object)sctx.mode()).thenReturn((Object)mode);
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.hasLabel(2)).thenReturn((Object)false);
        Mockito.when((Object)this.nodeCursor.hasLabel(3)).thenReturn((Object)true);
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("Label", 2));
        if (shoudldBeAuthorized) {
            this.assertAuthorized(executable);
            return null;
        }
        AuthorizationViolationException exception = (AuthorizationViolationException)org.junit.jupiter.api.Assertions.assertThrows(AuthorizationViolationException.class, (Executable)executable);
        return exception.getMessage();
    }

    private void assertAuthorized(Executable executable) throws Exception {
        try {
            executable.execute();
        }
        catch (AuthorizationViolationException e) {
            throw new AssertionFailedError(e.getMessage(), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted((Throwable)t);
            throw new AssertionFailedError("Unexpected exception thrown: " + t.getMessage(), t);
        }
    }

    private static Iterator<ConstraintDescriptor> asIterator(ConstraintDescriptor constraint) {
        return Collections.singletonList(constraint).iterator();
    }

    private void storageReaderWithConstraints(ConstraintDescriptor constraint) {
        Mockito.when((Object)this.storageReader.constraintsGetForSchema(constraint.schema())).thenReturn(OperationsTest.asIterator(constraint));
        Mockito.when((Object)this.storageReader.constraintExists(constraint)).thenReturn((Object)true);
    }

    private void storageReaderWithoutConstraints() {
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn(Iterables.empty().iterator());
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)ArgumentMatchers.any())).thenReturn((Object)false);
    }

    private void setStoreRelationship(long relationshipId, long sourceNode, long targetNode, int relationshipLabel) {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.relationshipCursor.relationshipReference()).thenReturn((Object)relationshipId);
        Mockito.when((Object)this.relationshipCursor.sourceNodeReference()).thenReturn((Object)sourceNode);
        Mockito.when((Object)this.relationshipCursor.targetNodeReference()).thenReturn((Object)targetNode);
        Mockito.when((Object)this.relationshipCursor.type()).thenReturn((Object)relationshipLabel);
    }
}

