/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;

class LazyInstanceSelectorTest {
    LazyInstanceSelectorTest() {
    }

    @Test
    void shouldInstantiateLazilyOnFirstSelect() {
        Function<IndexSlot, String> factory = LazyInstanceSelectorTest.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        for (IndexSlot slot : IndexSlot.values()) {
            for (IndexSlot candidate : IndexSlot.values()) {
                if (candidate.ordinal() < slot.ordinal()) {
                    ((Function)Mockito.verify(factory)).apply(candidate);
                    selector.select(candidate);
                    ((Function)Mockito.verify(factory)).apply(candidate);
                    continue;
                }
                if (candidate == slot) {
                    ((Function)Mockito.verify(factory, (VerificationMode)Mockito.times((int)0))).apply(candidate);
                    selector.select(candidate);
                    ((Function)Mockito.verify(factory)).apply(candidate);
                    continue;
                }
                Assertions.assertNull((Object)selector.getIfInstantiated(candidate));
            }
        }
    }

    @Test
    void shouldPerformActionOnAll() {
        Function<IndexSlot, String> factory = LazyInstanceSelectorTest.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        selector.select(IndexSlot.GENERIC);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        selector.forAll(consumer);
        for (IndexSlot slot : IndexSlot.values()) {
            ((Consumer)Mockito.verify((Object)consumer)).accept(String.valueOf(slot));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void shouldCloseAllInstantiated() {
        Function<IndexSlot, String> factory = LazyInstanceSelectorTest.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        selector.select(IndexSlot.LUCENE);
        selector.select(IndexSlot.GENERIC);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        selector.close(consumer);
        ((Consumer)Mockito.verify((Object)consumer)).accept(String.valueOf(IndexSlot.LUCENE));
        ((Consumer)Mockito.verify((Object)consumer)).accept(String.valueOf(IndexSlot.GENERIC));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{consumer});
    }

    @Test
    void shouldPreventInstantiationAfterClose() {
        Function<IndexSlot, String> factory = LazyInstanceSelectorTest.slotToStringFunction();
        LazyInstanceSelector selector = new LazyInstanceSelector(factory);
        selector.select(IndexSlot.LUCENE);
        selector.close((Consumer)Mockito.mock(Consumer.class));
        try {
            selector.select(IndexSlot.GENERIC);
            Assertions.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static Function<IndexSlot, String> slotToStringFunction() {
        Function factory = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)((String)factory.apply((IndexSlot)ArgumentMatchers.any(IndexSlot.class)))).then(invocationOnMock -> String.valueOf((IndexSlot)invocationOnMock.getArgument(0)));
        return factory;
    }
}

