/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.EnumMap;
import java.util.function.Function;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.NodeIdsIndexReaderQueryAnswer;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.values.storable.Value;

abstract class FusionIndexReaderTest {
    private static final int PROP_KEY = 1;
    private static final int LABEL_KEY = 11;
    private static final IndexDescriptor DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)11, (int[])new int[]{1})).withName("index").materialise(12L);
    private final FusionVersion fusionVersion;
    private IndexReader[] aliveReaders;
    private EnumMap<IndexSlot, IndexReader> readers;
    private FusionIndexReader fusionIndexReader;

    FusionIndexReaderTest(FusionVersion fusionVersion) {
        this.fusionVersion = fusionVersion;
    }

    @BeforeEach
    void setup() throws IndexNotApplicableKernelException {
        this.initiateMocks();
    }

    private void initiateMocks() throws IndexNotApplicableKernelException {
        IndexSlot[] activeSlots = this.fusionVersion.aliveSlots();
        this.readers = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.readers, IndexReader.EMPTY);
        this.aliveReaders = new IndexReader[activeSlots.length];
        block4: for (int i = 0; i < activeSlots.length; ++i) {
            IndexReader mock = (IndexReader)Mockito.mock(IndexReader.class);
            ((IndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(DESCRIPTOR, new long[0])).when((Object)mock)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (IndexQuery[])ArgumentMatchers.any());
            this.aliveReaders[i] = mock;
            switch (activeSlots[i]) {
                case GENERIC: {
                    this.readers.put(IndexSlot.GENERIC, mock);
                    continue block4;
                }
                case LUCENE: {
                    this.readers.put(IndexSlot.LUCENE, mock);
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexReader = new FusionIndexReader(this.fusionVersion.slotSelector(), new LazyInstanceSelector(this.readers, this.throwingFactory()), TestIndexDescriptorFactory.forLabel(11, 1));
    }

    private Function<IndexSlot, IndexReader> throwingFactory() {
        return i -> {
            throw new IllegalStateException("All readers should exist already");
        };
    }

    @Test
    void closeMustCloseBothNativeAndLucene() {
        this.fusionIndexReader.close();
        for (IndexReader reader : this.aliveReaders) {
            ((IndexReader)Mockito.verify((Object)reader)).close();
        }
    }

    @Test
    void closeIteratorMustCloseAll() throws Exception {
        IndexProgressor[] progressors = new IndexProgressor[this.aliveReaders.length];
        for (int i = 0; i < this.aliveReaders.length; ++i) {
            int slot = i;
            ((IndexReader)Mockito.doAnswer(invocation -> {
                IndexProgressor.EntityValueClient client = (IndexProgressor.EntityValueClient)invocation.getArgument(1);
                IndexProgressor progressor = (IndexProgressor)Mockito.mock(IndexProgressor.class);
                client.initialize(DESCRIPTOR, progressor, NodeIdsIndexReaderQueryAnswer.getIndexQueryArgument((InvocationOnMock)invocation), (IndexQueryConstraints)invocation.getArgument(2), false);
                progressors[slot] = progressor;
                return null;
            }).when((Object)this.aliveReaders[i])).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (IndexQuery[])ArgumentMatchers.any());
        }
        try (NodeValueIterator iterator = new NodeValueIterator();){
            this.fusionIndexReader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)iterator, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exists((int)1)});
        }
        for (IndexProgressor progressor : progressors) {
            ((IndexProgressor)Mockito.verify((Object)progressor)).close();
        }
    }

    @Test
    void countIndexedNodesMustSelectCorrectReader() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyCountIndexedNodesWithCorrectReader(this.readers.get(indexSlot), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyCountIndexedNodesWithCorrectReader(this.readers.get(IndexSlot.GENERIC), new Value[]{indexSlot, secondValue});
            }
        }
    }

    private void verifyCountIndexedNodesWithCorrectReader(IndexReader correct, Value ... nativeValue) {
        this.fusionIndexReader.countIndexedNodes(0L, PageCursorTracer.NULL, new int[]{1}, nativeValue);
        ((IndexReader)Mockito.verify((Object)correct)).countIndexedNodes(0L, PageCursorTracer.NULL, new int[]{1}, nativeValue);
        for (IndexReader reader : this.aliveReaders) {
            if (reader == correct) continue;
            ((IndexReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.never())).countIndexedNodes(0L, PageCursorTracer.NULL, new int[]{1}, nativeValue);
        }
    }

    @Test
    void mustSelectLuceneForCompositePredicate() throws Exception {
        this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.GENERIC), new IndexQuery[]{IndexQuery.exists((int)0), IndexQuery.exists((int)1)});
    }

    @Test
    void mustSelectLuceneForExactPredicateWithStringValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesSupportedByLucene()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.LUCENE), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    void mustSelectGenericForExactPredicateWithOtherValue() throws Exception {
        for (Value value : FusionIndexTestHelp.valuesNotSupportedBySpecificIndex()) {
            IndexQuery.ExactPredicate indexQuery = IndexQuery.exact((int)1, (Object)value);
            this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.GENERIC), new IndexQuery[]{indexQuery});
        }
    }

    @Test
    void mustSelectLuceneForRangeStringPredicate() throws Exception {
        IndexQuery.RangePredicate numberRange = IndexQuery.range((int)1, (String)"a", (boolean)true, (String)"b", (boolean)false);
        this.verifyQueryWithCorrectReader(this.readers.get(IndexSlot.LUCENE), new IndexQuery[]{numberRange});
    }

    @Test
    void mustCombineResultFromExistsPredicate() throws Exception {
        IndexQuery.ExistsPredicate exists = IndexQuery.exists((int)1);
        long lastId = 0L;
        for (IndexReader aliveReader : this.aliveReaders) {
            ((IndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(DESCRIPTOR, new long[]{lastId++, lastId++})).when((Object)aliveReader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (IndexQuery[])ArgumentMatchers.any());
        }
        try (NodeValueIterator result = new NodeValueIterator();){
            this.fusionIndexReader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)result, IndexQueryConstraints.unconstrained(), new IndexQuery[]{exists});
            MutableLongSet resultSet = PrimitiveLongCollections.asSet((LongIterator)result);
            for (long i = 0L; i < lastId; ++i) {
                Assertions.assertTrue((boolean)resultSet.contains(i), (String)("Expected to contain " + i + ", but was " + (LongSet)resultSet));
            }
        }
    }

    @Test
    void shouldInstantiatePartLazilyForSpecificValueGroupQuery() throws IndexNotApplicableKernelException {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot i : IndexSlot.values()) {
            if (this.readers.get(i) != IndexReader.EMPTY) {
                Value value = values.get(i)[0];
                try (NodeValueIterator cursor = new NodeValueIterator();){
                    this.fusionIndexReader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)cursor, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)0, (Object)value)});
                }
                for (IndexSlot j : IndexSlot.values()) {
                    if (this.readers.get(j) == IndexReader.EMPTY) continue;
                    if (i == j) {
                        ((IndexReader)Mockito.verify((Object)this.readers.get(i))).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), (IndexQuery[])ArgumentMatchers.any());
                        continue;
                    }
                    Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.readers.get(j)});
                }
            }
            this.initiateMocks();
        }
    }

    private void verifyQueryWithCorrectReader(IndexReader expectedReader, IndexQuery ... indexQuery) throws IndexNotApplicableKernelException {
        try (NodeValueIterator cursor = new NodeValueIterator();){
            this.fusionIndexReader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)cursor, IndexQueryConstraints.unconstrained(), indexQuery);
        }
        if (indexQuery.length == 1) {
            ((IndexReader)Mockito.verify((Object)expectedReader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), new IndexQuery[]{(IndexQuery)ArgumentMatchers.eq((Object)indexQuery[0])});
        } else {
            ((IndexReader)Mockito.verify((Object)expectedReader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexQueryConstraints)ArgumentMatchers.any(), new IndexQuery[]{(IndexQuery)ArgumentMatchers.eq((Object)indexQuery[0]), (IndexQuery)ArgumentMatchers.eq((Object)indexQuery[1])});
        }
        for (IndexReader reader : this.aliveReaders) {
            if (reader == expectedReader) continue;
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
        }
    }
}

