/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateStorage;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
class IndexUpdateStorageTest {
    private static final IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final SchemaDescriptorSupplier descriptor = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
    @Inject
    protected TestDirectory directory;
    @Inject
    protected RandomRule random;
    private final GenericLayout layout = new GenericLayout(1, spatialSettings);

    IndexUpdateStorageTest() {
    }

    @Test
    void shouldAddZeroEntries() throws IOException {
        try (IndexUpdateStorage storage = new IndexUpdateStorage(this.directory.getFileSystem(), this.directory.file("file", new String[0]), ByteBufferFactory.heapBufferFactory((int)0).globalAllocator(), 1000, (Layout)this.layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected = this.generateSomeUpdates(0);
            IndexUpdateStorageTest.storeAll((IndexUpdateStorage<GenericKey, NativeIndexValue>)storage, expected);
            IndexUpdateStorageTest.verify(expected, (IndexUpdateStorage<GenericKey, NativeIndexValue>)storage);
        }
    }

    @Test
    void shouldAddFewEntries() throws IOException {
        try (IndexUpdateStorage storage = new IndexUpdateStorage(this.directory.getFileSystem(), this.directory.file("file", new String[0]), ByteBufferFactory.heapBufferFactory((int)0).globalAllocator(), 1000, (Layout)this.layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected = this.generateSomeUpdates(5);
            IndexUpdateStorageTest.storeAll((IndexUpdateStorage<GenericKey, NativeIndexValue>)storage, expected);
            IndexUpdateStorageTest.verify(expected, (IndexUpdateStorage<GenericKey, NativeIndexValue>)storage);
        }
    }

    @Test
    void shouldAddManyEntries() throws IOException {
        try (IndexUpdateStorage storage = new IndexUpdateStorage(this.directory.getFileSystem(), this.directory.file("file", new String[0]), ByteBufferFactory.heapBufferFactory((int)0).globalAllocator(), 10000, (Layout)this.layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected = this.generateSomeUpdates(1000);
            IndexUpdateStorageTest.storeAll((IndexUpdateStorage<GenericKey, NativeIndexValue>)storage, expected);
            IndexUpdateStorageTest.verify(expected, (IndexUpdateStorage<GenericKey, NativeIndexValue>)storage);
        }
    }

    private static void storeAll(IndexUpdateStorage<GenericKey, NativeIndexValue> storage, List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected) throws IOException {
        for (IndexEntryUpdate<SchemaDescriptorSupplier> update : expected) {
            storage.add(update);
        }
        storage.doneAdding();
    }

    private static void verify(List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected, IndexUpdateStorage<GenericKey, NativeIndexValue> storage) throws IOException {
        try (IndexUpdateCursor reader = (IndexUpdateCursor)storage.reader();){
            for (IndexEntryUpdate<SchemaDescriptorSupplier> expectedUpdate : expected) {
                Assertions.assertTrue((boolean)reader.next());
                Assertions.assertEquals(expectedUpdate, IndexUpdateStorageTest.asUpdate((IndexUpdateCursor<GenericKey, NativeIndexValue>)reader));
            }
            Assertions.assertFalse((boolean)reader.next());
        }
    }

    private static IndexEntryUpdate<SchemaDescriptorSupplier> asUpdate(IndexUpdateCursor<GenericKey, NativeIndexValue> reader) {
        switch (reader.updateMode()) {
            case ADDED: {
                return IndexEntryUpdate.add((long)((GenericKey)reader.key()).getEntityId(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{((GenericKey)reader.key()).asValue()});
            }
            case CHANGED: {
                return IndexEntryUpdate.change((long)((GenericKey)reader.key()).getEntityId(), (SchemaDescriptorSupplier)descriptor, (Value)((GenericKey)reader.key()).asValue(), (Value)((GenericKey)reader.key2()).asValue());
            }
            case REMOVED: {
                return IndexEntryUpdate.remove((long)((GenericKey)reader.key()).getEntityId(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{((GenericKey)reader.key()).asValue()});
            }
        }
        throw new IllegalArgumentException();
    }

    private List<IndexEntryUpdate<SchemaDescriptorSupplier>> generateSomeUpdates(int count) {
        ArrayList<IndexEntryUpdate<SchemaDescriptorSupplier>> updates = new ArrayList<IndexEntryUpdate<SchemaDescriptorSupplier>>();
        block5: for (int i = 0; i < count; ++i) {
            long entityId = this.random.nextLong(10000000L);
            switch ((UpdateMode)this.random.among((Object[])UpdateMode.MODES)) {
                case ADDED: {
                    updates.add((IndexEntryUpdate<SchemaDescriptorSupplier>)IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{this.random.nextValue()}));
                    continue block5;
                }
                case REMOVED: {
                    updates.add((IndexEntryUpdate<SchemaDescriptorSupplier>)IndexEntryUpdate.remove((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{this.random.nextValue()}));
                    continue block5;
                }
                case CHANGED: {
                    updates.add((IndexEntryUpdate<SchemaDescriptorSupplier>)IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value)this.random.nextValue(), (Value)this.random.nextValue()));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return updates;
    }
}

