/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

class GenericLayoutTest {
    private static final IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());

    GenericLayoutTest() {
    }

    @Test
    void shouldHaveUniqueIdentifierForDifferentNumberOfSlots() {
        HashMap<Long, Integer> layouts = new HashMap<Long, Integer>();
        for (int i = 0; i < 100; ++i) {
            GenericLayout genericLayout = new GenericLayout(i, spatialSettings);
            Integer previous = layouts.put(genericLayout.identifier(), i);
            Assertions.assertNull((Object)previous, (String)String.format("Expected identifier to be unique for layout with different number of slots, but two had the same identifier, firstSlotCount=%s, secondSlotCount=%s.", previous, i));
        }
    }
}

