/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.memory.MemoryPools;
import org.neo4j.resources.CpuClock;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.Race;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

class KernelTransactionTerminationTest {
    private static final int TEST_RUN_TIME_SECS = 5;

    KernelTransactionTerminationTest() {
    }

    @Test
    @Timeout(value=100L)
    void transactionCantBeTerminatedAfterItIsClosed() throws Throwable {
        this.runTwoThreads(() -> {}, tx -> tx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed), tx -> {
            KernelTransactionTerminationTest.close((KernelTransaction)tx);
            Assertions.assertFalse((boolean)tx.getReasonIfTerminated().isPresent());
            tx.initialize();
        });
    }

    @Test
    @Timeout(value=100L)
    void closeTransaction() throws Throwable {
        LinkedBlockingQueue committerToTerminator = new LinkedBlockingQueue(1);
        LinkedBlockingQueue terminatorToCommitter = new LinkedBlockingQueue(1);
        AtomicBoolean t1Done = new AtomicBoolean();
        this.runTwoThreads(() -> {
            committerToTerminator.clear();
            terminatorToCommitter.clear();
            t1Done.set(false);
        }, tx -> {
            Boolean terminatorShouldAct = (Boolean)committerToTerminator.poll();
            if (terminatorShouldAct != null && terminatorShouldAct.booleanValue()) {
                TerminatorAction action = TerminatorAction.random();
                action.executeOn((KernelTransaction)tx);
                Assertions.assertTrue((boolean)terminatorToCommitter.add(action));
            }
            t1Done.set(true);
        }, tx -> {
            CommitterAction committerAction = CommitterAction.random();
            if (committerToTerminator.offer(true)) {
                TerminatorAction terminatorAction = null;
                try {
                    while (!t1Done.get() && terminatorAction == null) {
                        terminatorAction = (TerminatorAction)((Object)((Object)terminatorToCommitter.poll(10L, TimeUnit.MILLISECONDS)));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (terminatorAction != null) {
                    KernelTransactionTerminationTest.close(tx, committerAction, terminatorAction);
                }
            }
        });
    }

    private void runTwoThreads(Runnable cleaner, Consumer<TestKernelTransaction> thread1Action, Consumer<TestKernelTransaction> thread2Action) throws Throwable {
        TestKernelTransaction tx = TestKernelTransaction.create();
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        int limit = 20000;
        for (int i = 0; i < limit && System.currentTimeMillis() < endTime; ++i) {
            cleaner.run();
            tx.initialize();
            Race race = new Race().withRandomStartDelays(0, 10);
            race.withEndCondition(new BooleanSupplier[]{() -> System.currentTimeMillis() >= endTime});
            race.addContestant(() -> thread1Action.accept(tx), 1);
            race.addContestant(() -> thread2Action.accept(tx), 1);
            race.go();
        }
    }

    private static void close(KernelTransaction tx) {
        try {
            tx.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void close(TestKernelTransaction tx, CommitterAction committer, TerminatorAction terminator) {
        try {
            if (terminator == TerminatorAction.NONE) {
                committer.closeNotTerminated(tx);
            } else {
                committer.closeTerminated(tx);
            }
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CommitTrackingMonitor
    implements TransactionMonitor {
        volatile boolean committed;
        volatile boolean rolledBack;
        volatile boolean terminated;

        private CommitTrackingMonitor() {
        }

        public void transactionStarted() {
        }

        public void transactionFinished(boolean successful, boolean writeTx) {
            if (successful) {
                this.committed = true;
            } else {
                this.rolledBack = true;
            }
        }

        public void transactionTerminated(boolean writeTx) {
            this.terminated = true;
        }

        public void upgradeToWriteTransaction() {
        }

        void reset() {
            this.committed = false;
            this.rolledBack = false;
            this.terminated = false;
        }
    }

    private static class TestKernelTransaction
    extends KernelTransactionImplementation {
        final CommitTrackingMonitor monitor;

        TestKernelTransaction(CommitTrackingMonitor monitor, Dependencies dependencies) {
            super(Config.defaults(), (DatabaseTransactionEventListeners)Mockito.mock(DatabaseTransactionEventListeners.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (GlobalProcedures)Mockito.mock(GlobalProcedures.class), (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), (TransactionMonitor)monitor, (Pool)Mockito.mock(Pool.class), (SystemNanoClock)Clocks.fakeClock(), new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE), (DatabaseTracers)Mockito.mock(DatabaseTracers.class, (Answer)Mockito.RETURNS_MOCKS), (StorageEngine)Mockito.mock(StorageEngine.class, (Answer)Mockito.RETURNS_MOCKS), (AccessCapability)new CanWrite(), EmptyVersionContextSupplier.EMPTY, CollectionsFactorySupplier.ON_HEAP, (ConstraintSemantics)new StandardConstraintSemantics(), (SchemaState)Mockito.mock(SchemaState.class), DatabaseRule.mockedTokenHolders(), (IndexingService)Mockito.mock(IndexingService.class), (LabelScanStore)Mockito.mock(LabelScanStore.class), (RelationshipTypeScanStore)Mockito.mock(RelationshipTypeScanStore.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), dependencies, new TestDatabaseIdRepository().defaultDatabase(), LeaseService.NO_LEASES, MemoryPools.NO_TRACKING);
            this.monitor = monitor;
        }

        static TestKernelTransaction create() {
            Dependencies dependencies = new Dependencies();
            dependencies.satisfyDependency((Object)((GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class)));
            return new TestKernelTransaction(new CommitTrackingMonitor(), dependencies);
        }

        TestKernelTransaction initialize() {
            this.initialize(42L, 42L, (StatementLocks)new SimpleStatementLocks((Locks.Client)new NoOpClient()), KernelTransaction.Type.IMPLICIT, SecurityContext.AUTH_DISABLED, 0L, 1L, ClientConnectionInfo.EMBEDDED_CONNECTION);
            this.monitor.reset();
            return this;
        }

        void assertCommitted() {
            Assertions.assertTrue((boolean)this.monitor.committed);
        }

        void assertRolledBack() {
            Assertions.assertTrue((boolean)this.monitor.rolledBack);
        }

        void assertTerminated() {
            Assertions.assertEquals((Object)Status.Transaction.TransactionMarkedAsFailed, this.getReasonIfTerminated().get());
            Assertions.assertTrue((boolean)this.monitor.terminated);
        }

        void assertNotTerminated() {
            Assertions.assertFalse((boolean)this.getReasonIfTerminated().isPresent());
            Assertions.assertFalse((boolean)this.monitor.terminated);
        }
    }

    private static enum CommitterAction {
        NONE{

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertTerminated();
                tx.close();
                tx.assertRolledBack();
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertNotTerminated();
                tx.close();
                tx.assertRolledBack();
            }
        }
        ,
        MARK_SUCCESS{

            @Override
            void closeTerminated(TestKernelTransaction tx) {
                tx.assertTerminated();
                Assertions.assertThrows(TransactionTerminatedException.class, () -> ((TestKernelTransaction)tx).commit());
                tx.assertRolledBack();
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertNotTerminated();
                tx.commit();
                tx.assertCommitted();
            }
        }
        ,
        MARK_FAILURE{

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                NONE.closeTerminated(tx);
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                NONE.closeNotTerminated(tx);
            }
        };

        static final CommitterAction[] VALUES;

        abstract void closeTerminated(TestKernelTransaction var1) throws TransactionFailureException;

        abstract void closeNotTerminated(TestKernelTransaction var1) throws TransactionFailureException;

        static CommitterAction random() {
            return VALUES[ThreadLocalRandom.current().nextInt(VALUES.length)];
        }

        static {
            VALUES = CommitterAction.values();
        }
    }

    private static enum TerminatorAction {
        NONE{

            @Override
            void executeOn(KernelTransaction tx) {
            }
        }
        ,
        TERMINATE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed);
            }
        };


        abstract void executeOn(KernelTransaction var1);

        static TerminatorAction random() {
            return ThreadLocalRandom.current().nextBoolean() ? TERMINATE : NONE;
        }
    }
}

