/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class KernelTransactionAssertOpenTest
extends KernelTransactionTestBase {
    KernelTransactionAssertOpenTest() {
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"nodeExists", (read, write, schema) -> read.nodeExists(0L)}), Arguments.arguments((Object[])new Object[]{"singleRelationship", (read, write, schema) -> read.singleRelationship(0L, null)}), Arguments.arguments((Object[])new Object[]{"nodeCreate", (read, write, schema) -> write.nodeCreate()}), Arguments.arguments((Object[])new Object[]{"relationshipSetProperty", (read, write, schema) -> write.relationshipSetProperty(0L, 2, (Value)Values.longValue((long)42L))}), Arguments.arguments((Object[])new Object[]{"indexesGetAll", (read, write, schema) -> schema.indexesGetAll()}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldThrowNotInTransactionWhenTransactionClosedAndAccessingOperations(String name, Operation transactionOperation) throws KernelException {
        KernelTransactionImplementation transaction = this.newTransaction((LoginContext)AnonymousContext.write());
        transaction.commit();
        Assertions.assertThrows(NotInTransactionException.class, () -> KernelTransactionAssertOpenTest.lambda$shouldThrowNotInTransactionWhenTransactionClosedAndAccessingOperations$5(transactionOperation, (KernelTransaction)transaction));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldThrowNotInTransactionWhenTransactionClosedAndAttemptingOperations(String name, Operation transactionOperation) throws KernelException {
        KernelTransactionImplementation transaction = this.newTransaction((LoginContext)AnonymousContext.write());
        Read read = transaction.dataRead();
        Write write = transaction.dataWrite();
        SchemaRead schemaRead = transaction.schemaRead();
        transaction.commit();
        Assertions.assertThrows(NotInTransactionException.class, () -> transactionOperation.operate(read, write, schemaRead));
    }

    private static /* synthetic */ void lambda$shouldThrowNotInTransactionWhenTransactionClosedAndAccessingOperations$5(Operation transactionOperation, KernelTransaction transaction) throws Throwable {
        transactionOperation.operate(transaction.dataRead(), transaction.dataWrite(), transaction.schemaRead());
    }

    static interface Operation {
        public void operate(Read var1, Write var2, SchemaRead var3) throws KernelException;
    }
}

