/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.diagnostics.providers.ConfigDiagnostics;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;

class ConfigDiagnosticsTest {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final Log log = this.logProvider.getLog(ConfigDiagnostics.class);

    ConfigDiagnosticsTest() {
    }

    @Test
    void dumpConfigValues() {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.default_database, (Object)"testDb").set(GraphDatabaseSettings.max_concurrent_transactions, (Object)400).build();
        ConfigDiagnostics configDiagnostics = new ConfigDiagnostics(config);
        configDiagnostics.dump(this.log.infoLogger());
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"DBMS provided settings:", GraphDatabaseSettings.max_concurrent_transactions.name() + "=400", GraphDatabaseSettings.default_database.name() + "=testDb"}).doesNotContainMessage("No provided DBMS settings.");
    }

    @Test
    void dumpDefaultConfig() {
        Config config = Config.defaults();
        ConfigDiagnostics configDiagnostics = new ConfigDiagnostics(config);
        configDiagnostics.dump(this.log.infoLogger());
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"No provided DBMS settings."}).doesNotContainMessage("DBMS provided settings");
    }
}

