/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.RandomStringUtils;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.util.Preconditions;

public class TestDatabaseIdRepository
extends MapCachingDatabaseIdRepository {
    private final String defaultDatabaseName;
    private final Set<String> filterSet = new CopyOnWriteArraySet<String>();

    public TestDatabaseIdRepository() {
        this("neo4j");
    }

    public TestDatabaseIdRepository(Config config) {
        this((String)config.get(GraphDatabaseSettings.default_database));
    }

    public TestDatabaseIdRepository(String defaultDbName) {
        super((DatabaseIdRepository)new RandomDatabaseIdRepository());
        this.defaultDatabaseName = defaultDbName;
    }

    public NamedDatabaseId defaultDatabase() {
        return this.getRaw(this.defaultDatabaseName);
    }

    public NamedDatabaseId getRaw(String databaseName) {
        Optional databaseIdOpt = this.getByName(databaseName);
        Preconditions.checkState((boolean)databaseIdOpt.isPresent(), (String)(((Object)((Object)this)).getClass().getSimpleName() + " should always produce a " + NamedDatabaseId.class.getSimpleName() + " for any database name"));
        NamedDatabaseId databaseId = (NamedDatabaseId)databaseIdOpt.get();
        this.cache(databaseId);
        return databaseId;
    }

    public void filter(String databaseName) {
        this.filterSet.add(databaseName);
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
        Optional id = super.getByName(databaseName);
        Boolean nameIsFiltered = id.map(NamedDatabaseId::name).map(this.filterSet::contains).orElse(false);
        return nameIsFiltered != false ? Optional.empty() : id;
    }

    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        Optional id = super.getById(databaseId);
        Boolean uuidIsFiltered = id.map(this.filterSet::contains).orElse(false);
        return uuidIsFiltered != false ? Optional.empty() : id;
    }

    public static NamedDatabaseId randomNamedDatabaseId() {
        return new NamedDatabaseId(RandomStringUtils.randomAlphabetic((int)20), UUID.randomUUID());
    }

    public static DatabaseId randomDatabaseId() {
        return new DatabaseId(UUID.randomUUID());
    }

    public static Dependencies noOpSystemGraphInitializer() {
        return TestDatabaseIdRepository.noOpSystemGraphInitializer(Config.defaults());
    }

    public static Dependencies noOpSystemGraphInitializer(Config config) {
        return TestDatabaseIdRepository.noOpSystemGraphInitializer(new Dependencies(), config);
    }

    public static Dependencies noOpSystemGraphInitializer(DependencyResolver dependencies, Config config) {
        return TestDatabaseIdRepository.noOpSystemGraphInitializer(new Dependencies(dependencies), config);
    }

    private static Dependencies noOpSystemGraphInitializer(Dependencies dependencies, Config config) {
        dependencies.satisfyDependencies(new Object[]{SystemGraphInitializer.NO_OP, new TestDatabaseIdRepository(config)});
        return dependencies;
    }

    private static class RandomDatabaseIdRepository
    implements DatabaseIdRepository {
        private RandomDatabaseIdRepository() {
        }

        public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
            return Optional.of(new NamedDatabaseId(databaseName.name(), UUID.randomUUID()));
        }

        public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
            return Optional.of(new NamedDatabaseId("db" + databaseId.hashCode(), databaseId.uuid()));
        }
    }
}

