/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constraints;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;

class ConstraintDescriptorFactoryTest {
    private static final int LABEL_ID = 0;
    private static final int REL_TYPE_ID = 0;

    ConstraintDescriptorFactoryTest() {
    }

    @Test
    void shouldCreateExistsConstraintDescriptors() {
        NodeExistenceConstraintDescriptor desc = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.EXISTS);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        desc = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.EXISTS);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forRelType((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateUniqueConstraintDescriptors() {
        UniquenessConstraintDescriptor desc = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.UNIQUE);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateNodeKeyConstraintDescriptors() {
        NodeKeyConstraintDescriptor desc = ConstraintDescriptorFactory.nodeKeyForLabel((int)0, (int[])new int[]{1});
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.UNIQUE_EXISTS);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateConstraintDescriptorsFromSchema() {
        UniquenessConstraintDescriptor desc = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.UNIQUE);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        desc = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.UNIQUE_EXISTS);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1}));
        desc = ConstraintDescriptorFactory.existsForSchema((RelationTypeSchemaDescriptor)SchemaDescriptor.forRelType((int)0, (int[])new int[]{1}));
        Assertions.assertThat((Comparable)desc.type()).isEqualTo((Object)ConstraintType.EXISTS);
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptor.forRelType((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateEqualDescriptors() {
        UniquenessConstraintDescriptor desc1 = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        UniquenessConstraintDescriptor desc2 = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        desc2 = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        desc2 = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    void shouldGiveNiceUserDescriptions() {
        Assertions.assertThat((String)ConstraintDescriptorFactory.existsForLabel((int)1, (int[])new int[]{2}).withId(1L).withName("Constraint 1").userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("Constraint( id=1, name='Constraint 1', type='NODE PROPERTY EXISTENCE', schema=(:Label1 {property2}) )");
        Assertions.assertThat((String)ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{3}).withId(2L).withName("Constraint 2").userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("Constraint( id=2, name='Constraint 2', type='RELATIONSHIP PROPERTY EXISTENCE', schema=-[:RelType1 {property3}]- )");
        Assertions.assertThat((String)ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{4}).withId(3L).withName("Constraint 3").userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("Constraint( id=3, name='Constraint 3', type='UNIQUENESS', schema=(:Label2 {property4}) )");
    }
}

