/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingLongHashSetTest {
    private final MemoryMeter meter = new MemoryMeter();
    private MemoryPool memoryPool;
    private MemoryTracker memoryTracker;

    HeapTrackingLongHashSetTest() {
    }

    @BeforeEach
    void setUp() {
        this.memoryPool = new MemoryPools().pool(MemoryGroup.TRANSACTION, 0L, null);
        this.memoryTracker = new LocalMemoryTracker(this.memoryPool);
    }

    @Test
    void calculateEmptySize() {
        HeapTrackingLongHashSet longHashSet = HeapTrackingLongHashSet.createLongHashSet((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation((LongHashSet)longHashSet);
        longHashSet.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void reactToGrowth() {
        HeapTrackingLongHashSet longHashSet = HeapTrackingLongHashSet.createLongHashSet((MemoryTracker)this.memoryTracker);
        this.assertExactEstimation((LongHashSet)longHashSet);
        for (int i = 0; i < 200; ++i) {
            longHashSet.add((long)i);
        }
        this.assertExactEstimation((LongHashSet)longHashSet);
        Assertions.assertThat((long)this.memoryPool.usedHeap()).isGreaterThanOrEqualTo(this.memoryTracker.estimatedHeapMemory());
        longHashSet.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.memoryPool.usedHeap());
    }

    private void assertExactEstimation(LongHashSet longHashSet) {
        org.junit.jupiter.api.Assertions.assertEquals((long)(this.meter.measureDeep((Object)longHashSet) - this.meter.measureDeep((Object)this.memoryTracker)), (long)this.memoryTracker.estimatedHeapMemory());
    }
}

