/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.storemigration.IndexConfigMigrator;
import org.neo4j.kernel.impl.storemigration.IndexProviderMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.LogsUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;

public class DatabaseMigrator {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final DependencyResolver dependencyResolver;
    private final PageCache pageCache;
    private final JobScheduler jobScheduler;
    private final DatabaseLayout databaseLayout;
    private final LegacyTransactionLogsLocator legacyLogsLocator;
    private final StorageEngineFactory storageEngineFactory;

    public DatabaseMigrator(FileSystemAbstraction fs, Config config, LogService logService, DependencyResolver dependencyResolver, PageCache pageCache, JobScheduler jobScheduler, DatabaseLayout databaseLayout, LegacyTransactionLogsLocator legacyLogsLocator, StorageEngineFactory storageEngineFactory) {
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.dependencyResolver = dependencyResolver;
        this.pageCache = pageCache;
        this.jobScheduler = jobScheduler;
        this.databaseLayout = databaseLayout;
        this.legacyLogsLocator = legacyLogsLocator;
        this.storageEngineFactory = storageEngineFactory;
    }

    public void migrate() {
        StoreVersionCheck versionCheck = this.storageEngineFactory.versionCheck(this.fs, this.databaseLayout, this.config, this.pageCache, this.logService);
        LogsUpgrader logsUpgrader = new LogsUpgrader(this.fs, this.storageEngineFactory, this.databaseLayout, this.pageCache, this.legacyLogsLocator, this.config, this.dependencyResolver);
        VisibleMigrationProgressMonitor progress = new VisibleMigrationProgressMonitor(this.logService.getUserLog(DatabaseMigrator.class));
        LogProvider logProvider = this.logService.getInternalLogProvider();
        StoreUpgrader storeUpgrader = new StoreUpgrader(versionCheck, progress, this.config, this.fs, logProvider, logsUpgrader);
        List storeParticipants = this.storageEngineFactory.migrationParticipants(this.fs, this.config, this.pageCache, this.jobScheduler, this.logService);
        storeParticipants.forEach(storeUpgrader::addParticipant);
        IndexProviderMap indexProviderMap = (IndexProviderMap)this.dependencyResolver.resolveDependency(IndexProviderMap.class);
        Log userLog = this.logService.getUserLog(IndexConfigMigrator.class);
        IndexConfigMigrator indexConfigMigrator = new IndexConfigMigrator(this.fs, this.config, this.pageCache, this.logService, this.storageEngineFactory, indexProviderMap, userLog);
        storeUpgrader.addParticipant((StoreMigrationParticipant)indexConfigMigrator);
        IndexProviderMigrator indexProviderMigrator = new IndexProviderMigrator(this.fs, this.config, this.pageCache, this.logService, this.storageEngineFactory);
        storeUpgrader.addParticipant((StoreMigrationParticipant)indexProviderMigrator);
        indexProviderMap.accept(provider -> storeUpgrader.addParticipant(provider.storeMigrationParticipant(this.fs, this.pageCache, this.storageEngineFactory)));
        storeUpgrader.migrateIfNeeded(this.databaseLayout);
    }
}

