/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexCapability;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.SchemaIndexMigrator;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.values.storable.Value;

public class FusionIndexProvider
extends IndexProvider {
    private final boolean archiveFailedIndex;
    private final InstanceSelector<IndexProvider> providers;
    private final SlotSelector slotSelector;
    private final FileSystemAbstraction fs;

    public FusionIndexProvider(IndexProvider genericProvider, IndexProvider luceneProvider, SlotSelector slotSelector, IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructure, FileSystemAbstraction fs, boolean archiveFailedIndex) {
        super(descriptor, directoryStructure);
        this.archiveFailedIndex = archiveFailedIndex;
        this.slotSelector = slotSelector;
        this.providers = new InstanceSelector();
        this.fs = fs;
        this.fillProvidersSelector(genericProvider, luceneProvider);
        slotSelector.validateSatisfied(this.providers);
    }

    private void fillProvidersSelector(IndexProvider genericProvider, IndexProvider luceneProvider) {
        this.providers.put(IndexSlot.GENERIC, genericProvider);
        this.providers.put(IndexSlot.LUCENE, luceneProvider);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        EnumMap<IndexSlot, IndexDescriptor> descriptors = new EnumMap<IndexSlot, IndexDescriptor>(IndexSlot.class);
        EnumMap<IndexSlot, IndexCapability> capabilities = new EnumMap<IndexSlot, IndexCapability>(IndexSlot.class);
        for (IndexSlot slot : IndexSlot.values()) {
            IndexDescriptor result = this.providers.select(slot).completeConfiguration(index);
            descriptors.put(slot, result);
            capabilities.put(slot, result.getCapability());
        }
        IndexConfig config = index.getIndexConfig();
        for (IndexDescriptor result : descriptors.values()) {
            IndexConfig resultConfig = result.getIndexConfig();
            for (Pair entry : resultConfig.entries()) {
                config = config.withIfAbsent((String)entry.getOne(), (Value)entry.getTwo());
            }
        }
        if ((index = index.withIndexConfig(config)).getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability((IndexCapability)new FusionIndexCapability(this.slotSelector, new InstanceSelector<IndexCapability>(capabilities)));
        }
        return index;
    }

    public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory) {
        EnumMap populators = this.providers.map(provider -> provider.getPopulator(descriptor, samplingConfig, bufferFactory));
        return new FusionIndexPopulator(this.slotSelector, new InstanceSelector<IndexPopulator>(populators), descriptor.getId(), this.fs, this.directoryStructure(), this.archiveFailedIndex);
    }

    public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        EnumMap accessors = this.providers.map(provider -> provider.getOnlineAccessor(descriptor, samplingConfig));
        return new FusionIndexAccessor(this.slotSelector, new InstanceSelector<IndexAccessor>(accessors), descriptor, this.fs, this.directoryStructure());
    }

    public String getPopulationFailure(IndexDescriptor descriptor) {
        StringBuilder builder = new StringBuilder();
        this.providers.forAll(p -> this.writeFailure(p.getClass().getSimpleName(), builder, (IndexProvider)p, descriptor));
        return builder.toString();
    }

    private void writeFailure(String indexName, StringBuilder builder, IndexProvider provider, IndexDescriptor descriptor) {
        String failure = provider.getPopulationFailure(descriptor);
        if (StringUtils.isNotEmpty((CharSequence)failure)) {
            builder.append(indexName);
            builder.append(": ");
            builder.append(failure);
            builder.append(' ');
        }
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor) {
        List statesIterable = this.providers.transform(p -> p.getInitialState(descriptor));
        List states = Iterables.asList(statesIterable);
        if (states.contains(InternalIndexState.FAILED)) {
            return InternalIndexState.FAILED;
        }
        if (states.contains(InternalIndexState.POPULATING)) {
            return InternalIndexState.POPULATING;
        }
        return InternalIndexState.ONLINE;
    }

    public void validatePrototype(IndexPrototype prototype) {
        super.validatePrototype(prototype);
        for (IndexSlot slot : IndexSlot.values()) {
            this.providers.select(slot).validatePrototype(prototype);
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, StorageEngineFactory storageEngineFactory) {
        return new SchemaIndexMigrator("Schema indexes", fs, this.directoryStructure(), storageEngineFactory);
    }
}

