/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;

public class PhysicalLogVersionedStoreChannel
implements LogVersionedStoreChannel {
    private final StoreChannel delegateChannel;
    private final long version;
    private final byte formatVersion;
    private long position;
    private final File file;
    private final ChannelNativeAccessor nativeChannelAccessor;

    public PhysicalLogVersionedStoreChannel(StoreChannel delegateChannel, long version, byte formatVersion, File file, ChannelNativeAccessor nativeChannelAccessor) throws IOException {
        this.delegateChannel = delegateChannel;
        this.version = version;
        this.formatVersion = formatVersion;
        this.position = delegateChannel.position();
        this.file = file;
        this.nativeChannelAccessor = nativeChannelAccessor;
    }

    public File getFile() {
        return this.file;
    }

    public FileLock tryLock() throws IOException {
        return this.delegateChannel.tryLock();
    }

    public void writeAll(ByteBuffer src, long position) {
        throw new UnsupportedOperationException("Not needed");
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.advance(src.remaining());
        this.delegateChannel.writeAll(src);
    }

    public int read(ByteBuffer dst, long position) {
        throw new UnsupportedOperationException("Not needed");
    }

    public void readAll(ByteBuffer dst) throws IOException {
        this.delegateChannel.readAll(dst);
    }

    public void force(boolean metaData) throws IOException {
        this.delegateChannel.force(metaData);
    }

    public StoreChannel position(long newPosition) throws IOException {
        this.position = newPosition;
        return this.delegateChannel.position(newPosition);
    }

    public StoreChannel truncate(long size) throws IOException {
        return this.delegateChannel.truncate(size);
    }

    public FileChannel fileChannel() {
        return this.delegateChannel.fileChannel();
    }

    public int read(ByteBuffer dst) throws IOException {
        return (int)this.advance(this.delegateChannel.read(dst));
    }

    private long advance(long bytes) {
        if (bytes != -1L) {
            this.position += bytes;
        }
        return bytes;
    }

    public int write(ByteBuffer src) throws IOException {
        return (int)this.advance(this.delegateChannel.write(src));
    }

    public long position() {
        return this.position;
    }

    public long size() throws IOException {
        return this.delegateChannel.size();
    }

    public boolean isOpen() {
        return this.delegateChannel.isOpen();
    }

    public void close() throws IOException {
        this.nativeChannelAccessor.evictFromSystemCache(this.delegateChannel, this.version);
        this.delegateChannel.close();
    }

    public long write(ByteBuffer[] sources, int offset, int length) throws IOException {
        return this.advance(this.delegateChannel.write(sources, offset, length));
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.advance(this.delegateChannel.write(srcs));
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.advance(this.delegateChannel.read(dsts, offset, length));
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.advance(this.delegateChannel.read(dsts));
    }

    public long getVersion() {
        return this.version;
    }

    public byte getLogFormatVersion() {
        return this.formatVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalLogVersionedStoreChannel that = (PhysicalLogVersionedStoreChannel)o;
        return this.version == that.version && this.delegateChannel.equals(that.delegateChannel);
    }

    public int hashCode() {
        int result = this.delegateChannel.hashCode();
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public void flush() throws IOException {
        this.force(false);
    }
}

