/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.api.index.IndexProgressor;

public class LabelScanValueIndexProgressor
implements IndexProgressor,
Resource {
    private final PrimitiveLongResourceIterator ids;
    private final IndexProgressor.NodeLabelClient client;

    public LabelScanValueIndexProgressor(PrimitiveLongResourceIterator ids, IndexProgressor.NodeLabelClient client) {
        this.ids = ids;
        this.client = client;
    }

    public boolean next() {
        while (this.ids.hasNext()) {
            long id = this.ids.next();
            if (!this.client.acceptNode(id, null)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        this.ids.close();
    }
}

