/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.tracer;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.api.tracer.CountingLogCheckPointEvent;
import org.neo4j.kernel.impl.api.tracer.CountingLogRotateEvent;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogFileCreateEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;

public class DefaultTracer
implements DatabaseTracer {
    private final AtomicLong appendedBytes = new AtomicLong();
    private final CountingLogRotateEvent countingLogRotateEvent = new CountingLogRotateEvent();
    private final LogFileCreateEvent logFileCreateEvent = () -> this.appendedBytes.addAndGet(64L);
    private final CountingLogCheckPointEvent logCheckPointEvent = new CountingLogCheckPointEvent(this::appendLogBytes);
    private final LogAppendEvent logAppendEvent = new DefaultLogAppendEvent();
    private final CommitEvent commitEvent = new DefaultCommitEvent();
    private final TransactionEvent transactionEvent = new DefaultTransactionEvent();

    @Override
    public TransactionEvent beginTransaction() {
        return this.transactionEvent;
    }

    @Override
    public long appendedBytes() {
        return this.appendedBytes.get();
    }

    @Override
    public long numberOfLogRotations() {
        return this.countingLogRotateEvent.numberOfLogRotations();
    }

    @Override
    public long logRotationAccumulatedTotalTimeMillis() {
        return this.countingLogRotateEvent.logRotationAccumulatedTotalTimeMillis();
    }

    @Override
    public long lastLogRotationTimeMillis() {
        return this.countingLogRotateEvent.lastLogRotationTimeMillis();
    }

    @Override
    public long numberOfCheckPoints() {
        return this.logCheckPointEvent.numberOfCheckPoints();
    }

    @Override
    public long checkPointAccumulatedTotalTimeMillis() {
        return this.logCheckPointEvent.checkPointAccumulatedTotalTimeMillis();
    }

    @Override
    public long lastCheckpointTimeMillis() {
        return this.logCheckPointEvent.lastCheckpointTimeMillis();
    }

    @Override
    public LogCheckPointEvent beginCheckPoint() {
        return this.logCheckPointEvent;
    }

    private void appendLogBytes(LogPosition logPositionBeforeAppend, LogPosition logPositionAfterAppend) {
        if (logPositionAfterAppend.getLogVersion() != logPositionBeforeAppend.getLogVersion()) {
            throw new IllegalStateException("Appending to several log files is not supported.");
        }
        this.appendedBytes.addAndGet(logPositionAfterAppend.getByteOffset() - logPositionBeforeAppend.getByteOffset());
    }

    @Override
    public LogFileCreateEvent createLogFile() {
        return this.logFileCreateEvent;
    }

    private class DefaultLogAppendEvent
    implements LogAppendEvent {
        private DefaultLogAppendEvent() {
        }

        @Override
        public void appendToLogFile(LogPosition logPositionBeforeAppend, LogPosition logPositionAfterAppend) {
            DefaultTracer.this.appendLogBytes(logPositionBeforeAppend, logPositionAfterAppend);
        }

        @Override
        public void close() {
        }

        @Override
        public void setLogRotated(boolean logRotated) {
        }

        @Override
        public LogRotateEvent beginLogRotate() {
            return DefaultTracer.this.countingLogRotateEvent;
        }

        @Override
        public SerializeTransactionEvent beginSerializeTransaction() {
            return SerializeTransactionEvent.NULL;
        }

        @Override
        public LogForceWaitEvent beginLogForceWait() {
            return LogForceWaitEvent.NULL;
        }

        @Override
        public LogForceEvent beginLogForce() {
            return LogForceEvent.NULL;
        }
    }

    private class DefaultCommitEvent
    implements CommitEvent {
        private DefaultCommitEvent() {
        }

        @Override
        public void close() {
        }

        @Override
        public LogAppendEvent beginLogAppend() {
            return DefaultTracer.this.logAppendEvent;
        }

        @Override
        public StoreApplyEvent beginStoreApply() {
            return StoreApplyEvent.NULL;
        }
    }

    private class DefaultTransactionEvent
    implements TransactionEvent {
        private DefaultTransactionEvent() {
        }

        @Override
        public void setSuccess(boolean success) {
        }

        @Override
        public void setFailure(boolean failure) {
        }

        @Override
        public CommitEvent beginCommitEvent() {
            return DefaultTracer.this.commitEvent;
        }

        @Override
        public void close() {
        }

        @Override
        public void setTransactionWriteState(String transactionWriteState) {
        }

        @Override
        public void setReadOnly(boolean wasReadOnly) {
        }
    }
}

