/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.storageengine.api.StorageEngine;

public class DefaultForceOperation
implements CheckPointerImpl.ForceOperation {
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final StorageEngine storageEngine;

    public DefaultForceOperation(IndexingService indexingService, LabelScanStore labelScanStore, StorageEngine storageEngine) {
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.storageEngine = storageEngine;
    }

    @Override
    public void flushAndForce(IOLimiter ioLimiter) throws IOException {
        this.indexingService.forceAll(ioLimiter);
        this.labelScanStore.force(ioLimiter);
        this.storageEngine.flushAndForce(ioLimiter);
    }
}

