/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.NodeLabelUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.util.FeatureToggles;

public class DynamicIndexStoreView
implements IndexStoreView {
    private static final boolean USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION = FeatureToggles.flag(DynamicIndexStoreView.class, (String)"use.label.index", (boolean)true);
    private final NeoStoreIndexStoreView neoStoreIndexStoreView;
    private final LabelScanStore labelScanStore;
    protected final LockService locks;
    private final Log log;
    protected final Supplier<StorageReader> storageEngine;

    public DynamicIndexStoreView(NeoStoreIndexStoreView neoStoreIndexStoreView, LabelScanStore labelScanStore, LockService locks, Supplier<StorageReader> storageEngine, LogProvider logProvider) {
        this.neoStoreIndexStoreView = neoStoreIndexStoreView;
        this.locks = locks;
        this.labelScanStore = labelScanStore;
        this.storageEngine = storageEngine;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
        if (forceStoreScan || !USE_LABEL_INDEX_FOR_SCHEMA_INDEX_POPULATION || this.useAllNodeStoreScan(labelIds)) {
            return this.neoStoreIndexStoreView.visitNodes(labelIds, propertyKeyIdFilter, propertyUpdatesVisitor, labelUpdateVisitor, forceStoreScan);
        }
        return new LabelScanViewNodeStoreScan<FAILURE>(this.storageEngine.get(), this.locks, this.labelScanStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdateVisitor) {
        return new RelationshipStoreScan<FAILURE>(this.storageEngine.get(), this.locks, propertyUpdateVisitor, relationshipTypeIds, propertyKeyIdFilter);
    }

    private boolean useAllNodeStoreScan(int[] labelIds) {
        try {
            return ArrayUtils.isEmpty((int[])labelIds) || this.isEmptyLabelScanStore();
        }
        catch (Exception e) {
            this.log.error("Can not determine number of labeled nodes, falling back to all nodes scan.", (Throwable)e);
            return true;
        }
    }

    private boolean isEmptyLabelScanStore() throws Exception {
        return this.labelScanStore.isEmpty();
    }

    @Override
    public NodePropertyAccessor newPropertyAccessor() {
        return this.neoStoreIndexStoreView.newPropertyAccessor();
    }
}

