/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.kernel.impl.scheduler.TimeBasedTaskScheduler;
import org.neo4j.scheduler.CancelListener;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.util.concurrent.BinaryLatch;

final class ScheduledJobHandle
extends AtomicInteger
implements JobHandle {
    private static final int RUNNABLE = 0;
    private static final int SUBMITTED = 1;
    private static final int FAILED = 2;
    long nextDeadlineNanos;
    private final TimeBasedTaskScheduler scheduler;
    private final Group group;
    private final CopyOnWriteArrayList<CancelListener> cancelListeners;
    private final BinaryLatch handleRelease;
    private final Runnable task;
    private volatile JobHandle latestHandle;
    private volatile Throwable lastException;

    ScheduledJobHandle(TimeBasedTaskScheduler scheduler, Group group, Runnable task, long nextDeadlineNanos, long reschedulingDelayNanos) {
        this.scheduler = scheduler;
        this.group = group;
        this.nextDeadlineNanos = nextDeadlineNanos;
        this.handleRelease = new BinaryLatch();
        this.cancelListeners = new CopyOnWriteArrayList();
        boolean isRecurring = reschedulingDelayNanos > 0L;
        this.task = () -> {
            try {
                task.run();
                this.lastException = null;
            }
            catch (Throwable e) {
                this.lastException = e;
                if (!isRecurring) {
                    this.set(2);
                }
            }
            finally {
                if (this.compareAndSet(1, 0) && isRecurring) {
                    this.nextDeadlineNanos += reschedulingDelayNanos;
                    scheduler.enqueueTask(this);
                }
            }
        };
    }

    void submitIfRunnable(ThreadPoolManager pools) {
        if (this.compareAndSet(0, 1)) {
            this.latestHandle = pools.getThreadPool(this.group).submit(this.task);
            this.handleRelease.release();
        }
    }

    public void cancel() {
        this.set(2);
        JobHandle handle = this.latestHandle;
        if (handle != null) {
            handle.cancel();
        }
        for (CancelListener cancelListener : this.cancelListeners) {
            cancelListener.cancelled();
        }
        this.scheduler.cancelTask(this);
        this.handleRelease.release();
    }

    public void waitTermination() throws ExecutionException, InterruptedException {
        this.handleRelease.await();
        RuntimeException runtimeException = null;
        try {
            JobHandle handleDelegate = this.latestHandle;
            if (handleDelegate != null) {
                handleDelegate.waitTermination();
            }
        }
        catch (RuntimeException t) {
            runtimeException = t;
        }
        if (this.get() == 2) {
            Throwable exception = this.lastException;
            if (exception != null) {
                ExecutionException executionException = new ExecutionException(exception);
                if (runtimeException != null) {
                    executionException.addSuppressed(runtimeException);
                }
                throw executionException;
            }
            throw (RuntimeException)Exceptions.chain((Throwable)new CancellationException(), (Throwable)runtimeException);
        }
    }

    public void waitTermination(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported for repeating tasks.");
    }

    public void registerCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }
}

