/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.IndexProviderFactoryUtil;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSlotSelector30;
import org.neo4j.util.VisibleForTesting;

public class NativeLuceneFusionIndexProviderFactory30
extends AbstractIndexProviderFactory {
    public static final String KEY = GraphDatabaseSettings.SchemaIndex.NATIVE30.providerKey();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, GraphDatabaseSettings.SchemaIndex.NATIVE30.providerVersion());

    public NativeLuceneFusionIndexProviderFactory30() {
        super(KEY);
    }

    @Override
    protected Class loggingClass() {
        return FusionIndexProvider.class;
    }

    @Override
    public IndexProviderDescriptor descriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected IndexProvider internalCreate(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        return NativeLuceneFusionIndexProviderFactory30.create(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    @VisibleForTesting
    public static FusionIndexProvider create(PageCache pageCache, File databaseDirectory, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        IndexDirectoryStructure.Factory childDirectoryStructure = NativeLuceneFusionIndexProviderFactory30.subProviderDirectoryStructure(databaseDirectory);
        boolean isSingleInstance = operationalMode == OperationalMode.SINGLE;
        boolean readOnly = IndexProviderFactoryUtil.isReadOnly((Config)config, (boolean)isSingleInstance);
        boolean archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
        GenericNativeIndexProvider generic = new GenericNativeIndexProvider(childDirectoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly, config);
        LuceneIndexProvider lucene = IndexProviderFactoryUtil.luceneProvider((FileSystemAbstraction)fs, (IndexDirectoryStructure.Factory)childDirectoryStructure, (IndexProvider.Monitor)monitor, (Config)config, (boolean)isSingleInstance);
        return new FusionIndexProvider(generic, (IndexProvider)lucene, new FusionSlotSelector30(), DESCRIPTOR, IndexDirectoryStructure.directoriesByProvider((File)databaseDirectory), fs, archiveFailedIndex);
    }

    @VisibleForTesting
    public static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File databaseDirectory) {
        return NativeLuceneFusionIndexProviderFactory30.subProviderDirectoryStructure(databaseDirectory, DESCRIPTOR);
    }

    @VisibleForTesting
    public static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File databaseDirectory, IndexProviderDescriptor descriptor) {
        IndexDirectoryStructure parentDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((File)databaseDirectory).forProvider(descriptor);
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)parentDirectoryStructure);
    }
}

