/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.SystemNanoClock;

public class LogPruningImpl
implements LogPruning {
    private final Lock pruneLock = new ReentrantLock();
    private final FileSystemAbstraction fs;
    private final LogFiles logFiles;
    private final Log log;
    private final LogPruneStrategyFactory strategyFactory;
    private final SystemNanoClock clock;
    private final LogProvider logProvider;
    private volatile LogPruneStrategy pruneStrategy;

    public LogPruningImpl(FileSystemAbstraction fs, LogFiles logFiles, LogProvider logProvider, LogPruneStrategyFactory strategyFactory, SystemNanoClock clock, Config config) {
        this.fs = fs;
        this.logFiles = logFiles;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.strategyFactory = strategyFactory;
        this.clock = clock;
        this.pruneStrategy = strategyFactory.strategyFromConfigValue(fs, logFiles, logProvider, clock, (String)config.get(GraphDatabaseSettings.keep_logical_logs));
        config.addListener(GraphDatabaseSettings.keep_logical_logs, (prev, update) -> this.updateConfiguration((String)update));
    }

    private void updateConfiguration(String pruningConf) {
        LogPruneStrategy strategy;
        this.pruneStrategy = strategy = this.strategyFactory.strategyFromConfigValue(this.fs, this.logFiles, this.logProvider, this.clock, pruningConf);
        this.log.info("Retention policy updated to '" + strategy + "', which will take effect next time a checkpoint completes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneLogs(long upToVersion) {
        if (this.pruneLock.tryLock()) {
            try {
                CountingDeleter deleter = new CountingDeleter(this.logFiles, this.fs, upToVersion);
                LogPruneStrategy strategy = this.pruneStrategy;
                strategy.findLogVersionsToDelete(upToVersion).forEachOrdered(deleter);
                this.log.info(deleter.describeResult(strategy));
            }
            finally {
                this.pruneLock.unlock();
            }
        }
    }

    @Override
    public boolean mightHaveLogsToPrune() {
        return this.pruneStrategy.findLogVersionsToDelete(this.logFiles.getHighestLogVersion()).count() > 0L;
    }

    @Override
    public String describeCurrentStrategy() {
        return this.pruneStrategy.toString();
    }

    private static class CountingDeleter
    implements LongConsumer {
        private static final int NO_VERSION = -1;
        private final LogFiles logFiles;
        private final FileSystemAbstraction fs;
        private final long upToVersion;
        private long fromVersion;
        private long toVersion;

        private CountingDeleter(LogFiles logFiles, FileSystemAbstraction fs, long upToVersion) {
            this.logFiles = logFiles;
            this.fs = fs;
            this.upToVersion = upToVersion;
            this.fromVersion = -1L;
            this.toVersion = -1L;
        }

        @Override
        public void accept(long version) {
            this.fromVersion = this.fromVersion == -1L ? version : Math.min(this.fromVersion, version);
            this.toVersion = this.toVersion == -1L ? version : Math.max(this.toVersion, version);
            File logFile = this.logFiles.getLogFileForVersion(version);
            this.fs.deleteFile(logFile);
        }

        String describeResult(LogPruneStrategy strategy) {
            String pruned = this.fromVersion == -1L ? "No log version pruned" : (this.fromVersion == this.toVersion ? "Pruned log version " + this.fromVersion : "Pruned log versions " + this.fromVersion + " through " + this.toVersion);
            return pruned + ". The strategy used was '" + strategy + "'. Last checkpoint was made in log version " + this.upToVersion + ".";
        }
    }
}

