/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesSpan;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.TransactionMetaDataStore;

public class TransactionLogInitializer {
    private static final String RESET_TRANSACTION_OFFSET_TAG = "ResetTransactionOffset";
    private final FileSystemAbstraction fs;
    private final TransactionMetaDataStore store;

    public static LogFilesInitializer getLogFilesInitializer() {
        return (databaseLayout, store, fileSystem) -> {
            try {
                TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, store);
                initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory());
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Fail to create empty transaction log file.", (Throwable)e);
            }
        };
    }

    public TransactionLogInitializer(FileSystemAbstraction fs, TransactionMetaDataStore store) {
        this.fs = fs;
        this.store = store;
    }

    public void initializeEmptyLogFile(DatabaseLayout layout, File transactionLogsDirectory) throws IOException {
        this.store.resetLastClosedTransaction(this.store.getLastCommittedTransactionId(), this.store.getLastClosedTransactionId(), 64L, true);
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            this.appendEmptyTransactionAndCheckPoint(logFiles);
        }
    }

    public void initializeExistingLogFiles(DatabaseLayout layout, File transactionLogsDirectory) throws Exception {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory);){
            LogFiles logFiles = span.getLogFiles();
            LogHeader logHeader = logFiles.extractHeader(logFiles.getLowestLogVersion());
            ReadableLogChannel readableChannel = logFiles.getLogFile().getReader(logHeader.getStartPosition());
            try (LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)new VersionAwareLogEntryReader(false), (ReadableClosablePositionAwareChecksumChannel)readableChannel);){
                while (true) {
                    if (cursor.next()) {
                        LogEntry entry = cursor.get();
                        if (entry.getType() != 5) continue;
                        return;
                        continue;
                    }
                    break;
                }
            }
            this.appendEmptyTransactionAndCheckPoint(logFiles);
        }
    }

    private LogFilesSpan buildLogFiles(DatabaseLayout layout, File transactionLogsDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.builder(layout, this.fs).withLogVersionRepository((LogVersionRepository)this.store).withTransactionIdStore((TransactionIdStore)this.store).withStoreId(this.store.getStoreId()).withLogsDirectory(transactionLogsDirectory).build();
        return new LogFilesSpan(new Lifespan(new Lifecycle[]{logFiles}), logFiles);
    }

    private void appendEmptyTransactionAndCheckPoint(LogFiles logFiles) throws IOException {
        TransactionId committedTx = this.store.getLastCommittedTransaction();
        long timestamp = committedTx.commitTimestamp();
        long transactionId = committedTx.transactionId();
        FlushablePositionAwareChecksumChannel writableChannel = logFiles.getLogFile().getWriter();
        LogEntryWriter writer = new LogEntryWriter((WritableChecksumChannel)writableChannel);
        writer.writeStartEntry(timestamp, 1L, -559063315, ArrayUtils.EMPTY_BYTE_ARRAY);
        int checksum = writer.writeCommitEntry(transactionId, timestamp);
        LogPositionMarker marker = new LogPositionMarker();
        writableChannel.getCurrentPosition(marker);
        LogPosition position = marker.newPosition();
        writer.writeCheckPointEntry(position);
        this.store.setLastCommittedAndClosedTransactionId(transactionId, checksum, timestamp, position.getByteOffset(), position.getLogVersion());
    }
}

