/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

class TwoPhaseNodeForRelationshipLocking {
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long[] sortedNodeIds;
    private MutableLongSet relIds;
    private static final long[] EMPTY = new long[0];
    private final Locks.Client locks;
    private final LockTracer lockTracer;

    TwoPhaseNodeForRelationshipLocking(ThrowingConsumer<Long, KernelException> relIdAction, Locks.Client locks, LockTracer lockTracer) {
        this.relIdAction = relIdAction;
        this.locks = locks;
        this.lockTracer = lockTracer;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, KernelTransaction transaction, NodeCursor nodes) throws KernelException {
        boolean retry;
        do {
            retry = false;
            this.relIds = new LongHashSet();
            this.collectAndSortNodeIds(nodeId, transaction, nodes);
            this.lockAllNodes(this.sortedNodeIds);
            transaction.dataRead().singleNode(nodeId, nodes);
            if (!nodes.next()) continue;
            try (RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);){
                while (rels.next() && !retry) {
                    if (this.relIds.contains(rels.relationshipReference())) continue;
                    retry = true;
                    this.unlockAllNodes(this.sortedNodeIds);
                    this.sortedNodeIds = null;
                }
            }
        } while (retry);
        long[] sortedRelIds = this.relIds.toSortedArray();
        if (sortedRelIds.length > 0) {
            this.locks.acquireExclusive(this.lockTracer, (ResourceType)ResourceTypes.RELATIONSHIP, sortedRelIds);
            for (long relId : sortedRelIds) {
                this.relIdAction.accept((Object)relId);
            }
        }
    }

    private void collectAndSortNodeIds(long nodeId, KernelTransaction transaction, NodeCursor nodes) {
        LongHashSet nodeIdSet = new LongHashSet();
        nodeIdSet.add(nodeId);
        Read read = transaction.dataRead();
        read.singleNode(nodeId, nodes);
        if (!nodes.next()) {
            this.sortedNodeIds = EMPTY;
            return;
        }
        try (RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);){
            while (rels.next()) {
                this.relIds.add(rels.relationshipReference());
                nodeIdSet.add(rels.sourceNodeReference());
                nodeIdSet.add(rels.targetNodeReference());
            }
        }
        this.sortedNodeIds = nodeIdSet.toSortedArray();
    }

    private void lockAllNodes(long[] nodeIds) {
        this.locks.acquireExclusive(this.lockTracer, (ResourceType)ResourceTypes.NODE, nodeIds);
    }

    private void unlockAllNodes(long[] nodeIds) {
        this.locks.releaseExclusive((ResourceType)ResourceTypes.NODE, nodeIds);
    }
}

