/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.compress.ZipUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public abstract class IndexFiles {
    abstract File getStoreFile();

    abstract File getBase();

    public abstract void clear();

    public abstract void archiveIndex();

    public abstract void ensureDirectoryExist();

    public String toString() {
        return String.format("%s[base=%s,storeFile=%s]", this.getClass().getSimpleName(), this.getBase(), this.getStoreFile());
    }

    static void clearDirectory(FileSystemAbstraction fs, File directory) {
        try {
            fs.deleteRecursively(directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void clearSingleFile(FileSystemAbstraction fs, File file) {
        try {
            fs.deleteFileOrThrow(file);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void archiveIndex(FileSystemAbstraction fs, File directory) {
        if (fs.isDirectory(directory) && fs.fileExists(directory) && fs.listFiles(directory).length > 0) {
            try {
                ZipUtils.zip((FileSystemAbstraction)fs, (File)directory, (File)new File(directory.getParent(), "archive-" + directory.getName() + "-" + System.currentTimeMillis() + ".zip"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static void ensureDirectoryExists(FileSystemAbstraction fs, File directory) {
        try {
            fs.mkdirs(directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class SingleFile
    extends IndexFiles {
        private final FileSystemAbstraction fs;
        private final File singleFile;

        SingleFile(FileSystemAbstraction fs, File singleFile) {
            this.fs = fs;
            this.singleFile = singleFile;
        }

        @Override
        public File getStoreFile() {
            return this.singleFile;
        }

        @Override
        public File getBase() {
            return this.singleFile;
        }

        @Override
        public void clear() {
            SingleFile.clearSingleFile(this.fs, this.singleFile);
        }

        @Override
        public void archiveIndex() {
            SingleFile.archiveIndex(this.fs, this.getBase());
        }

        @Override
        public void ensureDirectoryExist() {
            SingleFile.ensureDirectoryExists(this.fs, this.singleFile.getParentFile());
        }
    }

    public static class Directory
    extends IndexFiles {
        private final FileSystemAbstraction fs;
        private final File directory;
        private final File storeFile;

        public Directory(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure, long indexId) {
            this.fs = fs;
            this.directory = directoryStructure.directoryForIndex(indexId);
            this.storeFile = new File(this.directory, Directory.indexFileName(indexId));
        }

        @Override
        public File getStoreFile() {
            return this.storeFile;
        }

        @Override
        public File getBase() {
            return this.directory;
        }

        @Override
        public void clear() {
            Directory.clearDirectory(this.fs, this.directory);
        }

        @Override
        public void archiveIndex() {
            Directory.archiveIndex(this.fs, this.getBase());
        }

        @Override
        public void ensureDirectoryExist() {
            Directory.ensureDirectoryExists(this.fs, this.directory);
        }

        private static String indexFileName(long indexId) {
            return "index-" + indexId;
        }
    }
}

