/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;

class NativeIndexUpdater<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexUpdater {
    private final KEY treeKey;
    private final VALUE treeValue;
    private final IndexDescriptor descriptor;
    private final TokenNameLookup tokenNameLookup;
    private final ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger = new ThrowingConflictDetector(true);
    private Writer<KEY, VALUE> writer;
    private boolean closed = true;

    NativeIndexUpdater(KEY treeKey, VALUE treeValue, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        this.treeKey = treeKey;
        this.treeValue = treeValue;
        this.descriptor = descriptor;
        this.tokenNameLookup = tokenNameLookup;
    }

    NativeIndexUpdater<KEY, VALUE> initialize(Writer<KEY, VALUE> writer) {
        if (!this.closed) {
            throw new IllegalStateException("Updater still open");
        }
        this.writer = writer;
        this.closed = false;
        return this;
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        this.assertOpen();
        NativeIndexUpdater.processUpdate(this.treeKey, this.treeValue, update, this.writer, this.conflictDetectingValueMerger, this.descriptor, this.tokenNameLookup);
    }

    public void close() {
        this.closed = true;
        IOUtils.closeAllUnchecked((AutoCloseable[])new Writer[]{this.writer});
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processUpdate(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) throws IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                NativeIndexUpdater.processAdd(treeKey, treeValue, update, writer, conflictDetectingValueMerger, descriptor, tokenNameLookup);
                break;
            }
            case CHANGED: {
                NativeIndexUpdater.processChange(treeKey, treeValue, update, writer, conflictDetectingValueMerger, descriptor, tokenNameLookup);
                break;
            }
            case REMOVED: {
                NativeIndexUpdater.processRemove(treeKey, update, writer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processRemove(KEY treeKey, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer) {
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, update.getEntityId(), update.values());
        writer.remove(treeKey);
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processChange(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) throws IndexEntryConflictException {
        try {
            NativeIndexUpdater.initializeKeyFromUpdate(treeKey, update.getEntityId(), update.beforeValues());
            writer.remove(treeKey);
            NativeIndexUpdater.initializeKeyFromUpdate(treeKey, update.getEntityId(), update.values());
            treeValue.from(update.values());
            conflictDetectingValueMerger.controlConflictDetection(treeKey);
            writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
            conflictDetectingValueMerger.checkConflict(update.values());
        }
        catch (Exception e) {
            Exceptions.withMessage((Throwable)e, (String)String.format("Failed while trying to write to index, targetIndex=%s, nodeId=%d. Cause: %s", descriptor.userDescription(tokenNameLookup), treeKey.getEntityId(), e.getMessage()));
            throw e;
        }
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processAdd(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) throws IndexEntryConflictException {
        try {
            NativeIndexUpdater.initializeKeyAndValueFromUpdate(treeKey, treeValue, update.getEntityId(), update.values());
            conflictDetectingValueMerger.controlConflictDetection(treeKey);
            writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
            conflictDetectingValueMerger.checkConflict(update.values());
        }
        catch (Exception e) {
            Exceptions.withMessage((Throwable)e, (String)String.format("Failed while trying to write to index, targetIndex=%s, nodeId=%d. Cause: %s", descriptor.userDescription(tokenNameLookup), treeKey.getEntityId(), e.getMessage()));
            throw e;
        }
    }

    static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void initializeKeyAndValueFromUpdate(KEY treeKey, VALUE treeValue, long entityId, Value[] values) {
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, entityId, values);
        treeValue.from(values);
    }

    static <KEY extends NativeIndexKey<KEY>> void initializeKeyFromUpdate(KEY treeKey, long entityId, Value[] values) {
        treeKey.initialize(entityId);
        for (int i = 0; i < values.length; ++i) {
            treeKey.initFromValue(i, values[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
    }
}

