/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipState;

class DefaultRelationshipGroupCursor
extends TraceableCursor
implements RelationshipGroupCursor {
    private Read read;
    private final CursorPool<DefaultRelationshipGroupCursor> pool;
    private StorageRelationshipGroupCursor storeCursor;
    private boolean hasCheckedTxState;
    private final MutableIntSet txTypes = new IntHashSet();
    private IntIterator txTypeIterator;
    private int currentTypeAddedInTx = -1;
    private boolean nodeIsDense;

    DefaultRelationshipGroupCursor(CursorPool<DefaultRelationshipGroupCursor> pool, StorageRelationshipGroupCursor storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    void init(long nodeReference, long reference, boolean nodeIsDense, Read read) {
        this.nodeIsDense = nodeIsDense;
        this.storeCursor.init(nodeReference, reference, nodeIsDense);
        this.txTypes.clear();
        this.txTypeIterator = null;
        this.currentTypeAddedInTx = -1;
        this.hasCheckedTxState = false;
        this.read = read;
    }

    public RelationshipGroupCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipGroupCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (!this.hasCheckedTxState) {
            this.checkTxStateForUpdates();
            this.hasCheckedTxState = true;
        }
        if (!this.storeCursor.next()) {
            boolean next = this.nextFromTxState();
            if (next && this.tracer != null) {
                this.tracer.onRelationshipGroup(this.type());
            }
            return next;
        }
        this.markTypeAsSeen(this.type());
        if (this.tracer != null) {
            this.tracer.onRelationshipGroup(this.type());
        }
        return true;
    }

    private boolean nextFromTxState() {
        if (this.txTypeIterator == null && !this.txTypes.isEmpty()) {
            this.txTypeIterator = this.txTypes.intIterator();
        }
        if (this.txTypeIterator != null) {
            if (this.txTypeIterator.hasNext()) {
                this.currentTypeAddedInTx = this.txTypeIterator.next();
                return true;
            }
            this.currentTypeAddedInTx = -1;
        }
        return false;
    }

    private void markTypeAsSeen(int type) {
        this.txTypes.remove(type);
    }

    private void checkTxStateForUpdates() {
        if (this.read.hasTxStateWithChanges()) {
            NodeState nodeState = this.read.txState().getNodeState(this.storeCursor.getOwningNode());
            LongIterator addedRelationships = nodeState.getAddedRelationships();
            while (addedRelationships.hasNext()) {
                RelationshipState relationshipState = this.read.txState().getRelationshipState(addedRelationships.next());
                relationshipState.accept((relationshipId, typeId, startNodeId, endNodeId) -> this.txTypes.add(typeId));
            }
        }
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.storeCursor.reset();
            if (this.pool != null) {
                this.pool.accept(this);
            }
        }
    }

    public int type() {
        return (long)this.currentTypeAddedInTx != -1L ? this.currentTypeAddedInTx : this.storeCursor.type();
    }

    public int outgoingCount() {
        int count = (long)this.currentTypeAddedInTx != -1L ? 0 : this.storeCursor.outgoingCount();
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.storeCursor.getOwningNode()).augmentDegree(RelationshipDirection.OUTGOING, count, this.type()) : count;
    }

    public int incomingCount() {
        int count = (long)this.currentTypeAddedInTx != -1L ? 0 : this.storeCursor.incomingCount();
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.storeCursor.getOwningNode()).augmentDegree(RelationshipDirection.INCOMING, count, this.type()) : count;
    }

    public int loopCount() {
        int count = (long)this.currentTypeAddedInTx != -1L ? 0 : this.storeCursor.loopCount();
        return this.read.hasTxStateWithChanges() ? this.read.txState().getNodeState(this.storeCursor.getOwningNode()).augmentDegree(RelationshipDirection.LOOP, count, this.type()) : count;
    }

    public void outgoing(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.storeCursor.getOwningNode(), this.outgoingReferenceWithoutFlags(), this.type(), RelationshipDirection.OUTGOING, this.nodeIsDense, this.read);
    }

    public void incoming(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.storeCursor.getOwningNode(), this.incomingReferenceWithoutFlags(), this.type(), RelationshipDirection.INCOMING, this.nodeIsDense, this.read);
    }

    public void loops(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.storeCursor.getOwningNode(), this.loopsReferenceWithoutFlags(), this.type(), RelationshipDirection.LOOP, this.nodeIsDense, this.read);
    }

    public long outgoingReference() {
        long reference = this.outgoingReferenceWithoutFlags();
        return reference == -1L ? RelationshipReferenceEncoding.encodeNoOutgoing(this.type()) : this.encodeSelectionToReference(reference);
    }

    public long incomingReference() {
        long reference = this.incomingReferenceWithoutFlags();
        return reference == -1L ? RelationshipReferenceEncoding.encodeNoIncoming(this.type()) : this.encodeSelectionToReference(reference);
    }

    public long loopsReference() {
        long reference = this.loopsReferenceWithoutFlags();
        return reference == -1L ? RelationshipReferenceEncoding.encodeNoLoops(this.type()) : this.encodeSelectionToReference(reference);
    }

    private long encodeSelectionToReference(long reference) {
        return this.nodeIsDense ? RelationshipReferenceEncoding.encodeDenseSelection(reference) : RelationshipReferenceEncoding.encodeSelection(reference);
    }

    private long outgoingReferenceWithoutFlags() {
        return this.relationshipReferenceWithoutFlags(this.storeCursor.outgoingReference());
    }

    private long incomingReferenceWithoutFlags() {
        return this.relationshipReferenceWithoutFlags(this.storeCursor.incomingReference());
    }

    private long loopsReferenceWithoutFlags() {
        return this.relationshipReferenceWithoutFlags(this.storeCursor.loopsReference());
    }

    private long relationshipReferenceWithoutFlags(long storeReference) {
        return (long)this.currentTypeAddedInTx != -1L ? -1L : storeReference;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipGroupCursor[closed state]";
        }
        return "RelationshipGroupCursor[" + this.storeCursor.toString() + "]";
    }

    public void release() {
        this.storeCursor.close();
    }
}

