/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.LocksNotFrozenException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.RestrictedSchemaWrite;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.FrozenStatementLocks;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.TransactionListenersState;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder,
ExecutionStatistics {
    private static final long NOT_COMMITTED_TRANSACTION_ID = -1L;
    private static final long NOT_COMMITTED_TRANSACTION_COMMIT_TIME = -1L;
    private final CollectionsFactory collectionsFactory;
    private final DatabaseTransactionEventListeners eventListeners;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StorageEngine storageEngine;
    private final TransactionTracer transactionTracer;
    private final Pool<KernelTransactionImplementation> pool;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final PageCursorTracerSupplier cursorTracerSupplier;
    private final VersionContextSupplier versionContextSupplier;
    private final LeaseService leaseService;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final NamedDatabaseId namedDatabaseId;
    private final ClockContext clocks;
    private final AccessCapability accessCapability;
    private final ConstraintSemantics constraintSemantics;
    private TxState txState;
    private volatile TransactionWriteState writeState;
    private final KernelStatement currentStatement;
    private SecurityContext securityContext;
    private volatile StatementLocks statementLocks;
    private volatile long userTransactionId;
    private LeaseClient leaseClient;
    private volatile boolean closing;
    private volatile boolean closed;
    private boolean failure;
    private boolean success;
    private volatile Status terminationReason;
    private long startTimeMillis;
    private volatile long startTimeNanos;
    private volatile long timeoutMillis;
    private long lastTransactionIdWhenStarted;
    private volatile long lastTransactionTimestampWhenStarted;
    private final Statistics statistics;
    private TransactionEvent transactionEvent;
    private KernelTransaction.Type type;
    private long transactionId;
    private long commitTime;
    private ClientConnectionInfo clientInfo;
    private volatile int reuseCount;
    private volatile Map<String, Object> userMetaData;
    private final AllStoreHolder allStoreHolder;
    private final Operations operations;
    private InternalTransaction internalTransaction;
    private volatile TraceProvider traceProvider;
    private volatile TransactionInitializationTrace initializationTrace;
    private final Lock terminationReleaseLock = new ReentrantLock();
    private PageCursorTracer pageCursorTracer;

    public KernelTransactionImplementation(Config config, DatabaseTransactionEventListeners eventListeners, ConstraintIndexCreator constraintIndexCreator, GlobalProcedures globalProcedures, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, Pool<KernelTransactionImplementation> pool, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef, TransactionTracer transactionTracer, LockTracer lockTracer, PageCursorTracerSupplier cursorTracerSupplier, StorageEngine storageEngine, AccessCapability accessCapability, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState, TokenHolders tokenHolders, IndexingService indexingService, LabelScanStore labelScanStore, IndexStatisticsStore indexStatisticsStore, Dependencies dependencies, NamedDatabaseId namedDatabaseId, LeaseService leaseService) {
        this.eventListeners = eventListeners;
        this.constraintIndexCreator = constraintIndexCreator;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.storageReader = storageEngine.newReader();
        this.commandCreationContext = storageEngine.newCommandCreationContext();
        this.namedDatabaseId = namedDatabaseId;
        this.storageEngine = storageEngine;
        this.pool = pool;
        this.clocks = new ClockContext(clock);
        this.transactionTracer = transactionTracer;
        this.cursorTracerSupplier = cursorTracerSupplier;
        this.versionContextSupplier = versionContextSupplier;
        this.leaseService = leaseService;
        this.currentStatement = new KernelStatement(this, lockTracer, this.clocks, versionContextSupplier, cpuClockRef, namedDatabaseId);
        this.accessCapability = accessCapability;
        this.statistics = new Statistics(this, cpuClockRef, heapAllocationRef);
        this.userMetaData = Collections.emptyMap();
        this.constraintSemantics = constraintSemantics;
        DefaultPooledCursors cursors = new DefaultPooledCursors(this.storageReader);
        this.allStoreHolder = new AllStoreHolder(this.storageReader, this, cursors, globalProcedures, schemaState, indexingService, labelScanStore, indexStatisticsStore, dependencies);
        this.operations = new Operations(this.allStoreHolder, this.storageReader, new IndexTxStateUpdater(this.storageReader, this.allStoreHolder, indexingService), this.commandCreationContext, this, new KernelToken(this.storageReader, this.commandCreationContext, this, tokenHolders), cursors, constraintIndexCreator, constraintSemantics, indexingService, config);
        this.traceProvider = TraceProviderFactory.getTraceProvider(config);
        this.registerConfigChangeListeners(config);
        this.collectionsFactory = collectionsFactorySupplier.create();
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, long lastTimeStamp, StatementLocks statementLocks, KernelTransaction.Type type, SecurityContext frozenSecurityContext, long transactionTimeout, long userTransactionId, ClientConnectionInfo clientInfo) {
        this.type = type;
        this.statementLocks = statementLocks;
        this.userTransactionId = userTransactionId;
        this.leaseClient = this.leaseService.newClient();
        this.statementLocks.initialize(this.leaseClient);
        this.terminationReason = null;
        this.closing = false;
        this.closed = false;
        this.failure = false;
        this.success = false;
        this.writeState = TransactionWriteState.NONE;
        this.startTimeMillis = this.clocks.systemClock().millis();
        this.startTimeNanos = this.clocks.systemClock().nanos();
        this.timeoutMillis = transactionTimeout;
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.lastTransactionTimestampWhenStarted = lastTimeStamp;
        this.transactionEvent = this.transactionTracer.beginTransaction();
        assert (this.transactionEvent != null) : "transactionEvent was null!";
        this.securityContext = frozenSecurityContext;
        this.transactionId = -1L;
        this.commitTime = -1L;
        this.clientInfo = clientInfo;
        this.pageCursorTracer = (PageCursorTracer)this.cursorTracerSupplier.get();
        this.statistics.init(Thread.currentThread().getId(), this.pageCursorTracer);
        this.currentStatement.initialize(statementLocks, this.pageCursorTracer, this.startTimeMillis);
        this.operations.initialize();
        this.initializationTrace = this.traceProvider.getTraceInfo();
        return this;
    }

    public void bindToUserTransaction(InternalTransaction internalTransaction) {
        this.internalTransaction = internalTransaction;
    }

    public InternalTransaction internalTransaction() {
        return this.internalTransaction;
    }

    int getReuseCount() {
        return this.reuseCount;
    }

    public long startTime() {
        return this.startTimeMillis;
    }

    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public long timeout() {
        return this.timeoutMillis;
    }

    public long lastTransactionIdWhenStarted() {
        return this.lastTransactionIdWhenStarted;
    }

    public void success() {
        this.success = true;
    }

    boolean isSuccess() {
        return this.success;
    }

    public void failure() {
        this.failure = true;
    }

    public Optional<Status> getReasonIfTerminated() {
        return Optional.ofNullable(this.terminationReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markForTermination(long expectedReuseCount, Status reason) {
        this.terminationReleaseLock.lock();
        try {
            boolean bl = expectedReuseCount == (long)this.reuseCount && this.markForTerminationIfPossible(reason);
            return bl;
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public void markForTermination(Status reason) {
        this.terminationReleaseLock.lock();
        try {
            this.markForTerminationIfPossible(reason);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public boolean isSchemaTransaction() {
        return this.writeState == TransactionWriteState.SCHEMA;
    }

    public PageCursorTracer pageCursorTracer() {
        return this.pageCursorTracer;
    }

    private boolean markForTerminationIfPossible(Status reason) {
        if (this.canBeTerminated()) {
            this.failure = true;
            this.terminationReason = reason;
            if (this.statementLocks != null) {
                this.statementLocks.stop();
            }
            this.transactionMonitor.transactionTerminated(this.hasTxStateWithChanges());
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    public SecurityContext securityContext() {
        if (this.securityContext == null) {
            throw new NotInTransactionException();
        }
        return this.securityContext;
    }

    public AuthSubject subjectOrAnonymous() {
        SecurityContext context = this.securityContext;
        return context == null ? AuthSubject.ANONYMOUS : context.subject();
    }

    public void setMetaData(Map<String, Object> data) {
        this.assertOpen();
        this.userMetaData = data;
    }

    public Map<String, Object> getMetaData() {
        return this.userMetaData;
    }

    public KernelStatement acquireStatement() {
        this.assertOpen();
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.operations.indexUniqueCreate(prototype);
    }

    public long pageHits() {
        return ((PageCursorTracer)this.cursorTracerSupplier.get()).hits();
    }

    public long pageFaults() {
        return ((PageCursorTracer)this.cursorTracerSupplier.get()).faults();
    }

    Optional<ExecutingQuery> executingQuery() {
        return this.currentStatement.executingQuery();
    }

    void upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToDataWrites();
    }

    private void upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToSchemaWrites();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            Iterator createdIndexIds = this.txState().constraintIndexesCreatedInTx();
            while (createdIndexIds.hasNext()) {
                IndexDescriptor createdIndex = (IndexDescriptor)createdIndexIds.next();
                this.constraintIndexCreator.dropUniquenessConstraintIndex(createdIndex);
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.leaseClient.ensureValid();
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txState = new TxState(this.collectionsFactory);
        }
        return this.txState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void markAsClosed() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
    }

    private void closeCurrentStatementIfAny() {
        this.currentStatement.forceClose();
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new NotInTransactionException("This transaction has already been closed.");
        }
    }

    public void assertOpen() {
        Status reason = this.terminationReason;
        if (reason != null) {
            throw new TransactionTerminatedException(reason);
        }
        this.assertTransactionOpen();
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges();
    }

    public long commit() throws TransactionFailureException {
        this.success();
        return this.closeTransaction();
    }

    public void rollback() throws TransactionFailureException {
        if (!this.isOpen() && this.failure) {
            return;
        }
        this.failure();
        this.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long closeTransaction() throws TransactionFailureException {
        block15: {
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closing = true;
            if (!this.failure && this.success && !this.isTerminated()) break block15;
            this.rollback(null);
            this.failOnNonExplicitRollbackIfNeeded();
            long l = -1L;
            try {
                this.closed = true;
                this.closing = false;
                this.transactionEvent.setSuccess(this.success);
                this.transactionEvent.setFailure(this.failure);
                this.transactionEvent.setTransactionWriteState(this.writeState.name());
                this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                this.transactionEvent.close();
                return l;
            }
            finally {
                this.release();
            }
        }
        long l = this.commitTransaction();
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionWriteState(this.writeState.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
            return l;
        }
        finally {
            this.release();
        }
        catch (TransactionFailureException e) {
            try {
                throw e;
                catch (KernelException e2) {
                    throw new TransactionFailureException(e2.status(), (Throwable)e2, "Unexpected kernel exception", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionWriteState(this.writeState.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                    throw throwable;
                }
                finally {
                    this.release();
                }
            }
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void failOnNonExplicitRollbackIfNeeded() throws TransactionFailureException {
        if (this.success && this.isTerminated()) {
            throw new TransactionTerminatedException(this.terminationReason);
        }
        if (this.success) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionMarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
        }
    }

    /*
     * Loose catch block
     */
    private long commitTransaction() throws KernelException {
        long l;
        CommitEvent commitEvent;
        TransactionListenersState listenersState;
        long txId;
        boolean success;
        block17: {
            block16: {
                success = false;
                txId = 0L;
                listenersState = null;
                commitEvent = this.transactionEvent.beginCommitEvent();
                listenersState = this.eventListeners.beforeCommit(this.txState, this, this.storageReader);
                if (listenersState != null && listenersState.isFailed()) {
                    Throwable cause = listenersState.failure();
                    throw new TransactionFailureException((Status)Status.Transaction.TransactionHookFailed, cause, "", new Object[0]);
                }
                if (this.hasChanges()) {
                    this.forceThawLocks();
                    this.statementLocks.prepareForCommit(this.currentStatement.lockTracer());
                    Locks.Client commitLocks = this.statementLocks.pessimistic();
                    ArrayList<StorageCommand> extractedCommands = new ArrayList<StorageCommand>();
                    this.storageEngine.createCommands(extractedCommands, (ReadableTransactionState)this.txState, this.storageReader, this.commandCreationContext, (ResourceLocker)commitLocks, this.lastTransactionIdWhenStarted, this::enforceConstraints);
                    if (!extractedCommands.isEmpty()) {
                        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(extractedCommands);
                        long timeCommitted = this.clocks.systemClock().millis();
                        transactionRepresentation.setHeader(ArrayUtils.EMPTY_BYTE_ARRAY, this.startTimeMillis, this.lastTransactionIdWhenStarted, timeCommitted, this.leaseClient.leaseId());
                        success = true;
                        TransactionToApply batch = new TransactionToApply((TransactionRepresentation)transactionRepresentation, this.versionContextSupplier.getVersionContext());
                        txId = this.commitProcess.commit(batch, commitEvent, TransactionApplicationMode.INTERNAL);
                        this.commitTime = timeCommitted;
                    }
                }
                success = true;
                l = txId;
                if (commitEvent != null) {
                    commitEvent.close();
                }
                if (success) break block16;
                this.rollback(listenersState);
                break block17;
            }
            this.transactionId = txId;
            this.afterCommit(listenersState);
        }
        return l;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (commitEvent != null) {
                            try {
                                commitEvent.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConstraintValidationException | CreateConstraintFailureException e) {
                        throw new ConstraintViolationTransactionFailureException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(this.tokenRead())), (KernelException)e);
                    }
                }
                catch (Throwable throwable3) {
                    if (!success) {
                        this.rollback(listenersState);
                    } else {
                        this.transactionId = txId;
                        this.afterCommit(listenersState);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private void rollback(TransactionListenersState listenersState) throws KernelException {
        try {
            try {
                this.dropCreatedConstraintIndexes();
            }
            catch (IllegalStateException | SecurityException e) {
                throw new TransactionFailureException((Status)Status.Transaction.TransactionRollbackFailed, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
            }
        }
        finally {
            this.afterRollback(listenersState);
        }
    }

    public Read dataRead() {
        return this.operations.dataRead();
    }

    public Write dataWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.assertAllowsWrites();
        this.upgradeToDataWrites();
        return this.operations;
    }

    public TokenWrite tokenWrite() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public Token token() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public TokenRead tokenRead() {
        return this.operations.token();
    }

    public SchemaRead schemaRead() {
        return this.operations.schemaRead();
    }

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.assertAllowsSchemaWrites();
        this.upgradeToSchemaWrites();
        return new RestrictedSchemaWrite(this.operations, this.securityContext());
    }

    public Locks locks() {
        return this.operations.locks();
    }

    public void freezeLocks() {
        StatementLocks locks = this.statementLocks;
        if (!(locks instanceof FrozenStatementLocks)) {
            this.statementLocks = new FrozenStatementLocks(locks);
        } else {
            ((FrozenStatementLocks)locks).freeze();
        }
    }

    public void thawLocks() throws LocksNotFrozenException {
        StatementLocks locks = this.statementLocks;
        if (locks instanceof FrozenStatementLocks) {
            FrozenStatementLocks frozenLocks = (FrozenStatementLocks)locks;
            if (frozenLocks.thaw()) {
                this.statementLocks = frozenLocks.getRealStatementLocks();
            }
        } else {
            throw new LocksNotFrozenException();
        }
    }

    private void forceThawLocks() {
        StatementLocks locks = this.statementLocks;
        if (locks instanceof FrozenStatementLocks) {
            this.statementLocks = ((FrozenStatementLocks)locks).getRealStatementLocks();
        }
    }

    public StatementLocks statementLocks() {
        this.assertOpen();
        return this.statementLocks;
    }

    public CursorFactory cursors() {
        return this.operations.cursors();
    }

    public Procedures procedures() {
        return this.operations.procedures();
    }

    public ExecutionStatistics executionStatistics() {
        return this;
    }

    public LockTracer lockTracer() {
        return this.currentStatement.lockTracer();
    }

    private void assertAllowsWrites() {
        AccessMode accessMode = this.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.securityContext().description()));
        }
    }

    private void assertAllowsSchemaWrites() {
        AccessMode accessMode = this.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.securityContext().description()));
        }
    }

    public final void assertAllowsTokenCreates(PrivilegeAction action) {
        AccessMode accessMode = this.securityContext().mode();
        if (!accessMode.allowsTokenCreates(action)) {
            throw accessMode.onViolation(String.format("'%s' operations are not allowed for %s.", action.toString(), this.securityContext().description()));
        }
    }

    private void afterCommit(TransactionListenersState listenersState) {
        try {
            this.markAsClosed();
            this.eventListeners.afterCommit(listenersState);
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxStateWithChanges());
        }
    }

    private void afterRollback(TransactionListenersState listenersState) {
        try {
            this.markAsClosed();
            this.eventListeners.afterRollback(listenersState);
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxStateWithChanges());
        }
    }

    void releaseStatementResources() {
        this.allStoreHolder.release();
    }

    private void release() {
        this.terminationReleaseLock.lock();
        try {
            this.forceThawLocks();
            this.statementLocks.close();
            this.statementLocks = null;
            this.terminationReason = null;
            this.type = null;
            this.securityContext = null;
            this.transactionEvent = null;
            this.txState = null;
            this.collectionsFactory.release();
            ++this.reuseCount;
            this.userMetaData = Collections.emptyMap();
            this.clientInfo = null;
            this.internalTransaction = null;
            this.userTransactionId = 0L;
            this.statistics.reset();
            this.releaseStatementResources();
            this.operations.release();
            this.pageCursorTracer.reportEvents();
            this.initializationTrace = null;
            this.pool.release((Object)this);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    private boolean canBeTerminated() {
        return !this.closed && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminationReason != null;
    }

    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    public KernelTransaction.Type transactionType() {
        return this.type;
    }

    public long getTransactionId() {
        if (this.transactionId == -1L) {
            throw new IllegalStateException("Transaction id is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.transactionId;
    }

    public long getCommitTime() {
        if (this.commitTime == -1L) {
            throw new IllegalStateException("Transaction commit time is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.commitTime;
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        SecurityContext oldContext = this.securityContext;
        this.securityContext = context;
        return () -> {
            this.securityContext = oldContext;
        };
    }

    public String toString() {
        return String.format("KernelTransaction[lease:%d]", this.leaseClient.leaseId());
    }

    public void dispose() {
        this.storageReader.close();
        this.commandCreationContext.close();
    }

    public Stream<? extends ActiveLock> activeLocks() {
        StatementLocks locks = this.statementLocks;
        return locks == null ? Stream.empty() : locks.activeLocks();
    }

    long userTransactionId() {
        return this.userTransactionId;
    }

    TransactionInitializationTrace getInitializationTrace() {
        return this.initializationTrace;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private TxStateVisitor enforceConstraints(TxStateVisitor txStateVisitor) {
        return this.constraintSemantics.decorateTxStateVisitor(this.storageReader, this.operations.dataRead(), this.operations.cursors(), this.txState, txStateVisitor);
    }

    public ClientConnectionInfo clientInfo() {
        return this.clientInfo;
    }

    public StorageReader newStorageReader() {
        return this.storageEngine.newReader();
    }

    public void addIndexDoDropToTxState(IndexDescriptor index) {
        this.txState().indexDoDrop(index);
    }

    public String getDatabaseName() {
        return this.namedDatabaseId.name();
    }

    public ClockContext clocks() {
        return this.clocks;
    }

    public NodeCursor ambientNodeCursor() {
        return this.operations.nodeCursor();
    }

    public RelationshipScanCursor ambientRelationshipCursor() {
        return this.operations.relationshipCursor();
    }

    public PropertyCursor ambientPropertyCursor() {
        return this.operations.propertyCursor();
    }

    private void registerConfigChangeListeners(Config config) {
        config.addListener(GraphDatabaseSettings.transaction_tracing_level, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider(config);
        });
        config.addListener(GraphDatabaseSettings.transaction_sampling_percentage, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider(config);
        });
    }

    private static enum TransactionWriteState {
        NONE,
        DATA{

            @Override
            TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }

    public static class Statistics {
        private volatile long cpuTimeNanosWhenQueryStarted;
        private volatile long heapAllocatedBytesWhenQueryStarted;
        private volatile long waitingTimeNanos;
        private volatile long transactionThreadId;
        private volatile PageCursorTracer pageCursorTracer = PageCursorTracer.NULL;
        private final KernelTransactionImplementation transaction;
        private final AtomicReference<CpuClock> cpuClockRef;
        private final AtomicReference<HeapAllocation> heapAllocationRef;
        private CpuClock cpuClock;
        private HeapAllocation heapAllocation;

        public Statistics(KernelTransactionImplementation transaction, AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef) {
            this.transaction = transaction;
            this.cpuClockRef = cpuClockRef;
            this.heapAllocationRef = heapAllocationRef;
        }

        protected void init(long threadId, PageCursorTracer pageCursorTracer) {
            this.cpuClock = this.cpuClockRef.get();
            this.heapAllocation = this.heapAllocationRef.get();
            this.transactionThreadId = threadId;
            this.pageCursorTracer = pageCursorTracer;
            this.cpuTimeNanosWhenQueryStarted = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            this.heapAllocatedBytesWhenQueryStarted = this.heapAllocation.allocatedBytes(this.transactionThreadId);
        }

        long heapAllocatedBytes() {
            return this.heapAllocation.allocatedBytes(this.transactionThreadId) - this.heapAllocatedBytesWhenQueryStarted;
        }

        long directAllocatedBytes() {
            return this.transaction.collectionsFactory.getMemoryTracker().usedDirectMemory();
        }

        public long cpuTimeMillis() {
            long cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.transactionThreadId) - this.cpuTimeNanosWhenQueryStarted;
            return TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos);
        }

        long totalTransactionPageCacheHits() {
            return this.pageCursorTracer.hits();
        }

        long totalTransactionPageCacheFaults() {
            return this.pageCursorTracer.faults();
        }

        void addWaitingTime(long waitTimeNanos) {
            this.waitingTimeNanos += waitTimeNanos;
        }

        long getWaitingTimeNanos(long nowNanos) {
            Optional<ExecutingQuery> query = this.transaction.executingQuery();
            long waitingTime = this.waitingTimeNanos;
            if (query.isPresent()) {
                long latestQueryWaitingNanos = query.get().totalWaitingTimeNanos(nowNanos);
                waitingTime += latestQueryWaitingNanos;
            }
            return waitingTime;
        }

        void reset() {
            this.pageCursorTracer = PageCursorTracer.NULL;
            this.cpuTimeNanosWhenQueryStarted = 0L;
            this.heapAllocatedBytesWhenQueryStarted = 0L;
            this.waitingTimeNanos = 0L;
            this.transactionThreadId = -1L;
        }
    }
}

