/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.kernel.database.DatabaseIdRepository;

public class DatabaseId {
    private final UUID uuid;

    DatabaseId(UUID uuid) {
        Objects.requireNonNull(uuid, "Database UUID should be not null.");
        this.uuid = uuid;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public boolean isSystemDatabase() {
        return DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.databaseId().equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseId that = (DatabaseId)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return "DatabaseIdWithoutName{uuid=" + this.uuid + "}";
    }
}

