/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ProcessRelationshipCountsDataStep
extends ProcessorStep<RelationshipRecord[]> {
    private final NodeLabelsCache cache;
    private final Map<Thread, RelationshipCountsProcessor> processors = new ConcurrentHashMap<Thread, RelationshipCountsProcessor>();
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final CountsAccessor.Updater countsUpdater;
    private final NumberArrayFactory cacheFactory;
    private final ProgressReporter progressMonitor;

    public ProcessRelationshipCountsDataStep(StageControl control, NodeLabelsCache cache, Configuration config, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, ProgressReporter progressReporter) {
        super(control, "COUNT", config, ProcessRelationshipCountsDataStep.numberOfProcessors(config, cache, highLabelId, highRelationshipTypeId), new StatsProvider[0]);
        this.cache = cache;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.countsUpdater = countsUpdater;
        this.cacheFactory = cacheFactory;
        this.progressMonitor = progressReporter;
    }

    private static int numberOfProcessors(Configuration config, NodeLabelsCache cache, int highLabelId, int highRelationshipTypeId) {
        GatheringMemoryStatsVisitor memVisitor = new GatheringMemoryStatsVisitor();
        cache.acceptMemoryStatsVisitor(memVisitor);
        long availableMem = config.maxMemoryUsage() - memVisitor.getTotalUsage();
        long threadMem = RelationshipCountsProcessor.calculateMemoryUsage(highLabelId, highRelationshipTypeId);
        long possibleThreads = availableMem / threadMem;
        return possibleThreads >= (long)config.maxNumberOfProcessors() ? 0 : Math.toIntExact(Math.max(1L, possibleThreads));
    }

    @Override
    protected void process(RelationshipRecord[] batch, BatchSender sender) {
        RelationshipCountsProcessor processor = this.processor();
        for (RelationshipRecord record : batch) {
            if (!record.inUse()) continue;
            processor.process(record);
        }
        this.progressMonitor.progress(batch.length);
    }

    private RelationshipCountsProcessor processor() {
        return this.processors.computeIfAbsent(Thread.currentThread(), k -> new RelationshipCountsProcessor(this.cache, this.highLabelId, this.highRelationshipTypeId, this.countsUpdater, this.cacheFactory));
    }

    @Override
    protected void done() {
        super.done();
        RelationshipCountsProcessor all = null;
        for (RelationshipCountsProcessor processor : this.processors.values()) {
            if (all == null) {
                all = processor;
                continue;
            }
            all.addCountsFrom(processor);
        }
        if (all != null) {
            all.done();
        }
        for (RelationshipCountsProcessor processor : this.processors.values()) {
            processor.close();
        }
    }
}

