/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.FileSystemIndexDropAction;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.ValueCategory;

public class GenericNativeIndexProvider
extends NativeIndexProvider<GenericKey, NativeIndexValue, GenericLayout> {
    public static final String KEY = GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion());
    public static final IndexCapability CAPABILITY = new GenericIndexCapability();
    public static final String BLOCK_BASED_POPULATION_NAME = "blockBasedPopulation";
    private final boolean blockBasedPopulation = FeatureToggles.flag(GenericNativeIndexPopulator.class, (String)"blockBasedPopulation", (boolean)false);
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final boolean archiveFailedIndex;
    private final IndexDropAction dropAction;

    GenericNativeIndexProvider(IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, Config config) {
        super(DESCRIPTOR, directoryStructureFactory, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
        this.configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        this.configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration(config);
        this.archiveFailedIndex = config.get(GraphDatabaseSettings.archive_failed_index);
        this.dropAction = new FileSystemIndexDropAction(fs, this.directoryStructure());
    }

    @Override
    GenericLayout layout(StoreIndexDescriptor descriptor, File storeFile) {
        try {
            int numberOfSlots = descriptor.properties().length;
            HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
            if (storeFile != null && this.fs.fileExists(storeFile)) {
                GBPTree.readHeader((PageCache)this.pageCache, (File)storeFile, (Header.Reader)new NativeIndexHeaderReader(new SpaceFillingCurveSettingsReader(settings)));
            }
            return new GenericLayout(numberOfSlots, new IndexSpecificSpaceFillingCurveSettingsCache(this.configuredSettings, settings));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, GenericLayout layout, StoreIndexDescriptor descriptor, ByteBufferFactory bufferFactory) {
        if (this.blockBasedPopulation) {
            return new GenericBlockBasedIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.directoryStructure(), this.configuration, this.dropAction, this.archiveFailedIndex, bufferFactory);
        }
        return new WorkSyncedNativeIndexPopulator<GenericKey, NativeIndexValue>(new GenericNativeIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.directoryStructure(), this.configuration, this.dropAction, this.archiveFailedIndex));
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, GenericLayout layout, StoreIndexDescriptor descriptor) {
        return new GenericNativeIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, this.dropAction);
    }

    @Override
    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return CAPABILITY;
    }

    private static class GenericIndexCapability
    implements IndexCapability {
        private final IndexLimitation[] limitations = new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS};

        private GenericIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.supportOrdering(valueCategories)) {
                return IndexCapability.ORDER_BOTH;
            }
            return IndexCapability.ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.YES;
        }

        public boolean isFulltextIndex() {
            return false;
        }

        public boolean isEventuallyConsistent() {
            return false;
        }

        private boolean supportOrdering(ValueCategory[] valueCategories) {
            for (ValueCategory valueCategory : valueCategories) {
                if (valueCategory != ValueCategory.GEOMETRY && valueCategory != ValueCategory.GEOMETRY_ARRAY && valueCategory != ValueCategory.UNKNOWN) continue;
                return false;
            }
            return true;
        }

        public IndexLimitation[] limitations() {
            return this.limitations;
        }
    }
}

