/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

class TransactionLogFilesHelper {
    private static final String REGEX_DEFAULT_NAME = "neostore\\.transaction\\.db";
    private static final String VERSION_SUFFIX = ".";
    private static final String REGEX_VERSION_SUFFIX = "\\.";
    static final FilenameFilter DEFAULT_FILENAME_FILTER = new LogicalLogFilenameFilter("neostore\\.transaction\\.db");
    private final File logBaseName;
    private final FilenameFilter logFileFilter;

    TransactionLogFilesHelper(File directory, String name) {
        this.logBaseName = new File(directory, name);
        this.logFileFilter = new LogicalLogFilenameFilter(name);
    }

    File getLogFileForVersion(long version) {
        return new File(this.logBaseName.getPath() + VERSION_SUFFIX + version);
    }

    long getLogVersion(String historyLogFilename) {
        int index = historyLogFilename.lastIndexOf(VERSION_SUFFIX);
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFilename + "'");
        }
        return Long.parseLong(historyLogFilename.substring(index + VERSION_SUFFIX.length()));
    }

    File getParentDirectory() {
        return this.logBaseName.getParentFile();
    }

    FilenameFilter getLogFilenameFilter() {
        return this.logFileFilter;
    }

    private static final class LogicalLogFilenameFilter
    implements FilenameFilter {
        private final Pattern logFilenamePattern;

        LogicalLogFilenameFilter(String name) {
            this.logFilenamePattern = Pattern.compile(name + TransactionLogFilesHelper.REGEX_VERSION_SUFFIX + ".*");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.logFilenamePattern.matcher(name).matches();
        }
    }
}

