/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Map;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

final class SpatialIndexConfig {
    private static final String SPATIAL_CONFIG_PREFIX = "spatial";

    private SpatialIndexConfig() {
    }

    static void addSpatialConfig(Map<String, Value> map, CoordinateReferenceSystem crs, SpaceFillingCurveSettings settings) {
        String crsName = crs.getName();
        int tableId = crs.getTable().getTableId();
        int code = crs.getCode();
        int dimensions = settings.getDimensions();
        int maxLevels = settings.getMaxLevels();
        double[] min = settings.indexExtents().getMin();
        double[] max = settings.indexExtents().getMax();
        String prefix = SpatialIndexConfig.prefix(crsName);
        map.put(prefix + ".tableId", (Value)Values.intValue((int)tableId));
        map.put(prefix + ".code", (Value)Values.intValue((int)code));
        map.put(prefix + ".dimensions", (Value)Values.intValue((int)dimensions));
        map.put(prefix + ".maxLevels", (Value)Values.intValue((int)maxLevels));
        map.put(prefix + ".min", (Value)Values.doubleArray((double[])min));
        map.put(prefix + ".max", (Value)Values.doubleArray((double[])max));
    }

    private static String prefix(String crsName) {
        return "spatial." + crsName;
    }
}

